/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.writer;

import org.apache.asterix.runtime.writer.AbstractPathResolver;
import org.apache.asterix.runtime.writer.DynamicPathResolver;
import org.apache.asterix.runtime.writer.ExternalWriter;
import org.apache.asterix.runtime.writer.IExternalFilePrinterFactory;
import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.asterix.runtime.writer.IExternalFileWriterFactory;
import org.apache.asterix.runtime.writer.StaticPathResolver;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriter;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExternalWriterFactory
implements IExternalWriterFactory {
    private static final long serialVersionUID = 1412969574113419638L;
    private final IExternalFileWriterFactory writerFactory;
    private final IExternalFilePrinterFactory printerFactory;
    private final String fileExtension;
    private final int maxResult;
    private final IScalarEvaluatorFactory pathEvalFactory;
    private final String staticPath;
    private final SourceLocation pathSourceLocation;

    public ExternalWriterFactory(IExternalFileWriterFactory writerFactory, IExternalFilePrinterFactory printerFactory, String fileExtension, int maxResult, IScalarEvaluatorFactory pathEvalFactory, String staticPath, SourceLocation pathSourceLocation) {
        this.writerFactory = writerFactory;
        this.printerFactory = printerFactory;
        this.fileExtension = fileExtension;
        this.maxResult = maxResult;
        this.pathEvalFactory = pathEvalFactory;
        this.staticPath = staticPath;
        this.pathSourceLocation = pathSourceLocation;
    }

    public IExternalWriter createWriter(IHyracksTaskContext context) throws HyracksDataException {
        AbstractPathResolver resolver;
        int partition = context.getTaskAttemptId().getTaskId().getPartition();
        char fileSeparator = this.writerFactory.getSeparator();
        if (this.staticPath == null) {
            EvaluatorContext evaluatorContext = new EvaluatorContext(context);
            IScalarEvaluator pathEval = this.pathEvalFactory.createScalarEvaluator((IEvaluatorContext)evaluatorContext);
            IWarningCollector warningCollector = context.getWarningCollector();
            resolver = new DynamicPathResolver(this.fileExtension, fileSeparator, partition, pathEval, warningCollector, this.pathSourceLocation);
        } else {
            resolver = new StaticPathResolver(this.fileExtension, fileSeparator, partition, this.staticPath);
        }
        IExternalFileWriter writer = this.writerFactory.createWriter(context, this.printerFactory);
        return new ExternalWriter(resolver, writer, this.maxResult);
    }
}

