/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.storage.am.btree.frames.BTreeNSMLeafFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReader;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReaderWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnMetadata;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeWriteLeafFrame;

public class ColumnBTreeLeafFrameFactory
implements ITreeIndexFrameFactory {
    private static final long serialVersionUID = 4136035898137820322L;
    private final ITreeIndexTupleWriterFactory rowTupleWriterFactory;
    private final AbstractColumnTupleReaderWriterFactory columnTupleWriterFactory;

    public ColumnBTreeLeafFrameFactory(ITreeIndexTupleWriterFactory rowTupleWriterFactory, AbstractColumnTupleReaderWriterFactory columnTupleWriterFactory) {
        this.rowTupleWriterFactory = rowTupleWriterFactory;
        this.columnTupleWriterFactory = columnTupleWriterFactory;
    }

    public ITreeIndexFrame createFrame() {
        return new BTreeNSMLeafFrame(this.rowTupleWriterFactory.createTupleWriter());
    }

    public ITreeIndexTupleWriterFactory getTupleWriterFactory() {
        return this.rowTupleWriterFactory;
    }

    public ColumnBTreeWriteLeafFrame createWriterFrame(IColumnMetadata columnMetadata) {
        ITreeIndexTupleWriter rowTupleWriter = this.rowTupleWriterFactory.createTupleWriter();
        AbstractColumnTupleWriter columnTupleWriter = this.columnTupleWriterFactory.createColumnWriter(columnMetadata);
        return new ColumnBTreeWriteLeafFrame(rowTupleWriter, columnTupleWriter);
    }

    public ColumnBTreeReadLeafFrame createReadFrame(IColumnProjectionInfo columnProjectionInfo) {
        ITreeIndexTupleWriter rowTupleWriter = this.rowTupleWriterFactory.createTupleWriter();
        AbstractColumnTupleReader columnTupleReader = this.columnTupleWriterFactory.createColumnReader(columnProjectionInfo);
        return new ColumnBTreeReadLeafFrame(rowTupleWriter, columnTupleReader);
    }
}

