/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReader;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.AbstractColumnBTreeLeafFrame;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public final class ColumnBTreeReadLeafFrame
extends AbstractColumnBTreeLeafFrame {
    private final AbstractColumnTupleReader columnarTupleReader;
    private final ITreeIndexTupleReference leftMostTuple;
    private final ITreeIndexTupleReference rightMostTuple;

    public ColumnBTreeReadLeafFrame(ITreeIndexTupleWriter rowTupleWriter, AbstractColumnTupleReader columnarTupleReader) {
        super(rowTupleWriter);
        this.columnarTupleReader = columnarTupleReader;
        this.leftMostTuple = rowTupleWriter.createTupleReference();
        this.rightMostTuple = rowTupleWriter.createTupleReference();
    }

    @Override
    public ITupleReference getLeftmostTuple() {
        if (this.getTupleCount() == 0) {
            return null;
        }
        this.leftMostTuple.setFieldCount(this.cmp.getKeyFieldCount());
        this.leftMostTuple.resetByTupleOffset(this.buf.array(), this.buf.getInt(9));
        return this.leftMostTuple;
    }

    @Override
    public ITupleReference getRightmostTuple() {
        if (this.getTupleCount() == 0) {
            return null;
        }
        this.rightMostTuple.setFieldCount(this.cmp.getKeyFieldCount());
        this.rightMostTuple.resetByTupleOffset(this.buf.array(), this.buf.getInt(13));
        return this.rightMostTuple;
    }

    public IColumnTupleIterator createTupleReference(int index, IColumnReadMultiPageOp multiPageOp) {
        return this.columnarTupleReader.createTupleIterator(this, index, multiPageOp);
    }

    @Override
    public int getTupleCount() {
        return this.buf.getInt(0);
    }

    public int getPageId() {
        return BufferedFileHandle.getPageId((long)((CachedPage)this.page).getDiskPageId());
    }

    public int getNumberOfColumns() {
        return this.buf.getInt(4);
    }

    public int getColumnOffset(int columnIndex) {
        if (columnIndex >= this.getNumberOfColumns()) {
            throw new IndexOutOfBoundsException(columnIndex + " >= " + this.getNumberOfColumns());
        }
        return this.columnarTupleReader.getColumnOffset(this.buf, columnIndex);
    }

    AbstractColumnTupleReader getColumnarTupleReader() {
        return this.columnarTupleReader;
    }

    int getNextLeaf() {
        return this.buf.getInt(26);
    }

    @Override
    public ITreeIndexTupleReference createTupleReference() {
        throw new IllegalArgumentException("Use createTupleReference(int)");
    }
}

