/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FullTextFilterEntity {
    private static final FullTextFilterEntity FULL_TEXT_CONFIG = new FullTextFilterEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FULL_TEXT_FILTER, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("FullTextFilterName")), 0, FullTextFilterEntity.fullTextFilterType(), true, new int[]{0, 1}), 2, -1);
    private static final FullTextFilterEntity DB_FULL_TEXT_CONFIG = new FullTextFilterEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FULL_TEXT_FILTER, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("FullTextFilterName")), 0, FullTextFilterEntity.databaseFullTextFilterType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int filterNameIndex;
    private final int filterTypeIndex;

    private FullTextFilterEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.filterNameIndex = startIndex++;
        this.filterTypeIndex = startIndex++;
    }

    public static FullTextFilterEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FULL_TEXT_CONFIG : FULL_TEXT_CONFIG;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int filterNameIndex() {
        return this.filterNameIndex;
    }

    public int filterTypeIndex() {
        return this.filterTypeIndex;
    }

    private static ARecordType fullTextFilterType() {
        return MetadataRecordTypes.createRecordType("FullTextFilterRecordType", new String[]{"DataverseName", "FullTextFilterName", "FullTextFilterType"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseFullTextFilterType() {
        return MetadataRecordTypes.createRecordType("FullTextFilterRecordType", new String[]{"DatabaseName", "DataverseName", "FullTextFilterName", "FullTextFilterType"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }
}

