/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.DataverseEntity;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DataverseTupleTranslator
extends AbstractTupleTranslator<Dataverse> {
    private final DataverseEntity dataverseEntity;
    private AMutableInt32 aInt32;

    protected DataverseTupleTranslator(boolean getTuple, DataverseEntity dataverseEntity) {
        super(getTuple, dataverseEntity.getIndex(), dataverseEntity.payloadPosition());
        this.dataverseEntity = dataverseEntity;
        if (getTuple) {
            this.aInt32 = new AMutableInt32(-1);
        }
    }

    @Override
    protected Dataverse createMetadataEntityFromARecord(ARecord dataverseRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)dataverseRecord.getValueByPos(this.dataverseEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.dataverseEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)dataverseRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String format = ((AString)dataverseRecord.getValueByPos(this.dataverseEntity.dataFormatIndex())).getStringValue();
        int pendingOp = ((AInt32)dataverseRecord.getValueByPos(this.dataverseEntity.pendingOpIndex())).getIntegerValue();
        return new Dataverse(databaseName, dataverseName, format, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Dataverse dataverse) throws HyracksDataException {
        String dataverseCanonicalName = dataverse.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.dataverseEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(dataverse.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.dataverseEntity.getRecordType());
        if (this.dataverseEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(dataverse.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.dataverseEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.dataverseEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataverse.getDataFormat());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.dataverseEntity.dataFormatIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.dataverseEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataverse.getPendingOp());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.dataverseEntity.pendingOpIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

