/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IMetadataLockUtil;
import org.apache.asterix.common.metadata.LockList;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockUtil
implements IMetadataLockUtil {
    public void createDatabaseBegin(IMetadataLockManager lockMgr, LockList locks, String database) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
    }

    public void dropDatabaseBegin(IMetadataLockManager lockMgr, LockList locks, String database) throws AlgebricksException {
        lockMgr.acquireDatabaseWriteLock(locks, database);
    }

    public void createDataverseBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseWriteLock(locks, database, dataverseName);
    }

    public void dropDataverseBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseWriteLock(locks, database, dataverseName);
    }

    public void createDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName, String itemTypeDatabase, DataverseName itemTypeDataverseName, String itemTypeName, boolean itemTypeAnonymous, String metaItemTypeDatabase, DataverseName metaItemTypeDataverseName, String metaItemTypeName, boolean metaItemTypeAnonymous, String nodeGroupName, String compactionPolicyName, boolean isDefaultCompactionPolicy, DatasetConfig.DatasetType datasetType, Object datasetDetails) throws AlgebricksException {
        this.createDatasetBeginPre(lockMgr, locks, database, dataverseName, itemTypeDatabase, itemTypeDataverseName, itemTypeName, itemTypeAnonymous, metaItemTypeDatabase, metaItemTypeDataverseName, metaItemTypeName, metaItemTypeAnonymous, nodeGroupName, compactionPolicyName, isDefaultCompactionPolicy);
        lockMgr.acquireDatasetWriteLock(locks, database, dataverseName, datasetName);
    }

    protected final void createDatasetBeginPre(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String itemTypeDatabase, DataverseName itemTypeDataverseName, String itemTypeName, boolean itemTypeAnonymous, String metaItemTypeDatabase, DataverseName metaItemTypeDataverseName, String metaItemTypeName, boolean metaItemTypeAnonymous, String nodeGroupName, String compactionPolicyName, boolean isDefaultCompactionPolicy) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        MetadataLockUtil.lockIfDifferentNamespace(lockMgr, locks, database, dataverseName, itemTypeDatabase, itemTypeDataverseName);
        MetadataLockUtil.lockIfDifferentNamespace(lockMgr, locks, database, dataverseName, itemTypeDatabase, itemTypeDataverseName, metaItemTypeDatabase, metaItemTypeDataverseName);
        if (itemTypeAnonymous) {
            lockMgr.acquireDataTypeWriteLock(locks, itemTypeDatabase, itemTypeDataverseName, itemTypeName);
        } else {
            lockMgr.acquireDataTypeReadLock(locks, itemTypeDatabase, itemTypeDataverseName, itemTypeName);
        }
        if (metaItemTypeDatabase != null && metaItemTypeDataverseName != null && !MetadataLockUtil.sameNamespace(metaItemTypeDatabase, metaItemTypeDataverseName, itemTypeDatabase, itemTypeDataverseName) && !metaItemTypeName.equals(itemTypeName)) {
            if (metaItemTypeAnonymous) {
                lockMgr.acquireDataTypeWriteLock(locks, metaItemTypeDatabase, metaItemTypeDataverseName, metaItemTypeName);
            } else {
                lockMgr.acquireDataTypeReadLock(locks, metaItemTypeDatabase, metaItemTypeDataverseName, metaItemTypeName);
            }
        }
        if (nodeGroupName != null) {
            lockMgr.acquireNodeGroupReadLock(locks, nodeGroupName);
        }
        if (!isDefaultCompactionPolicy) {
            lockMgr.acquireMergePolicyReadLock(locks, compactionPolicyName);
        }
    }

    public void createIndexBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName, String fullTextConfigName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetCreateIndexLock(locks, database, dataverseName, datasetName);
        if (!Strings.isNullOrEmpty((String)fullTextConfigName)) {
            lockMgr.acquireFullTextConfigReadLock(locks, database, dataverseName, fullTextConfigName);
        }
    }

    public void dropIndexBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, database, dataverseName, datasetName);
    }

    public void createTypeBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, database, dataverseName, typeName);
    }

    public void dropDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, database, dataverseName, datasetName);
    }

    public void dropTypeBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDataTypeWriteLock(locks, database, dataverseName, typeName);
    }

    public void createLibraryBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireLibraryWriteLock(locks, database, dataverseName, libraryName);
    }

    public void dropLibraryBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireLibraryWriteLock(locks, database, dataverseName, libraryName);
    }

    public void createFunctionBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String functionName, String libraryDatabase, DataverseName libraryDataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFunctionWriteLock(locks, database, dataverseName, functionName);
        if (libraryName != null) {
            MetadataLockUtil.lockIfDifferentNamespace(lockMgr, locks, database, dataverseName, libraryDatabase, libraryDataverseName);
            lockMgr.acquireLibraryReadLock(locks, libraryDatabase, libraryDataverseName, libraryName);
        }
    }

    public void dropFunctionBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String functionName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFunctionWriteLock(locks, database, dataverseName, functionName);
    }

    public void createFullTextFilterBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFullTextFilterWriteLock(locks, database, dataverseName, fullTextFilterName);
    }

    public void dropFullTextFilterBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFullTextFilterWriteLock(locks, database, dataverseName, fullTextFilterName);
    }

    public void createFullTextConfigBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String fullTextConfigName, ImmutableList<String> fullTextFilterNames) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFullTextConfigWriteLock(locks, database, dataverseName, fullTextConfigName);
        ArrayList<String> fullTextFilterNamesMutable = new ArrayList<String>((Collection<String>)fullTextFilterNames);
        Collections.sort(fullTextFilterNamesMutable);
        for (String filterName : fullTextFilterNamesMutable) {
            lockMgr.acquireFullTextFilterReadLock(locks, database, dataverseName, filterName);
        }
    }

    public void dropFullTextConfigBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String configName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFullTextConfigWriteLock(locks, database, dataverseName, configName);
    }

    public void createAdapterBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String adapterName, String libraryDatabase, DataverseName libraryDataverseName, String libraryName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireAdapterWriteLock(locks, database, dataverseName, adapterName);
        if (libraryName != null) {
            MetadataLockUtil.lockIfDifferentNamespace(lockMgr, locks, database, dataverseName, libraryDatabase, libraryDataverseName);
            lockMgr.acquireLibraryReadLock(locks, libraryDatabase, libraryDataverseName, libraryName);
        }
    }

    public void dropAdapterBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireAdapterWriteLock(locks, database, dataverseName, adapterName);
    }

    public void createSynonymBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireSynonymWriteLock(locks, database, dataverseName, synonymName);
    }

    public void dropSynonymBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireSynonymWriteLock(locks, database, dataverseName, synonymName);
    }

    public void modifyDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetModifyLock(locks, database, dataverseName, datasetName);
    }

    public void insertDeleteUpsertBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetExclusiveModificationLock(locks, database, dataverseName, datasetName);
    }

    public void dropFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, database, dataverseName, feedName);
    }

    public void dropFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, database, dataverseName, policyName);
    }

    public void startFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, database, dataverseName, feedName);
    }

    public void stopFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, database, dataverseName, feedName);
    }

    public void createFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityWriteLock(locks, database, dataverseName, feedName);
    }

    public void connectFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, database, dataverseName, feedName);
        lockMgr.acquireDatasetReadLock(locks, database, dataverseName, datasetName);
    }

    public void createFeedPolicyBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireFeedPolicyWriteLock(locks, database, dataverseName, policyName);
    }

    public void disconnectFeedBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName, String feedName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireActiveEntityReadLock(locks, database, dataverseName, feedName);
        lockMgr.acquireDatasetReadLock(locks, database, dataverseName, datasetName);
    }

    public void analyzeDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetCreateIndexLock(locks, database, dataverseName, datasetName);
    }

    public void analyzeDatasetDropBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetWriteLock(locks, database, dataverseName, datasetName);
    }

    public void compactBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetReadLock(locks, database, dataverseName, datasetName);
    }

    public void refreshDatasetBegin(IMetadataLockManager lockMgr, LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        lockMgr.acquireDatabaseReadLock(locks, database);
        lockMgr.acquireDataverseReadLock(locks, database, dataverseName);
        lockMgr.acquireDatasetExclusiveModificationLock(locks, database, dataverseName, datasetName);
    }

    private static void lockIfDifferentNamespace(IMetadataLockManager lockMgr, LockList locks, String lockedDatabase, DataverseName lockedDataverse, String toBeLockedDatabase, DataverseName toBeLockedDataverse) throws AlgebricksException {
        if (toBeLockedDatabase != null && toBeLockedDataverse != null) {
            if (!Objects.equals(lockedDatabase, toBeLockedDatabase)) {
                lockMgr.acquireDatabaseReadLock(locks, toBeLockedDatabase);
                lockMgr.acquireDataverseReadLock(locks, toBeLockedDatabase, toBeLockedDataverse);
            } else if (!Objects.equals(lockedDataverse, toBeLockedDataverse)) {
                lockMgr.acquireDataverseReadLock(locks, toBeLockedDatabase, toBeLockedDataverse);
            }
        }
    }

    private static void lockIfDifferentNamespace(IMetadataLockManager lockMgr, LockList locks, String lockedDatabase1, DataverseName lockedDataverse1, String lockedDatabase2, DataverseName lockedDataverse2, String toBeLockedDatabase, DataverseName toBeLockedDataverse) throws AlgebricksException {
        if (toBeLockedDatabase != null && toBeLockedDataverse != null) {
            if (!Objects.equals(lockedDatabase1, toBeLockedDatabase)) {
                if (!Objects.equals(lockedDatabase2, toBeLockedDatabase)) {
                    lockMgr.acquireDatabaseReadLock(locks, toBeLockedDatabase);
                    lockMgr.acquireDataverseReadLock(locks, toBeLockedDatabase, toBeLockedDataverse);
                } else if (!Objects.equals(lockedDataverse2, toBeLockedDataverse)) {
                    lockMgr.acquireDataverseReadLock(locks, toBeLockedDatabase, toBeLockedDataverse);
                }
            } else if (!Objects.equals(lockedDataverse1, toBeLockedDataverse)) {
                lockMgr.acquireDataverseReadLock(locks, toBeLockedDatabase, toBeLockedDataverse);
            }
        }
    }

    private static boolean sameNamespace(String database1, DataverseName dataverse1, String database2, DataverseName dataverse2) {
        return database1.equals(database2) && dataverse1.equals((Object)dataverse2);
    }
}

