/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.filter.ExternalFilterEvaluatorFactory;
import org.apache.asterix.external.input.filter.ExternalFilterValueEvaluatorFactory;
import org.apache.asterix.external.input.filter.NoOpExternalFilterEvaluatorFactory;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.metadata.utils.filter.AbstractFilterBuilder;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.projection.ExternalDatasetProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;

public class ExternalFilterBuilder
extends AbstractFilterBuilder {
    private final ExternalDataPrefix prefix;
    private final boolean embedFilterValues;

    public ExternalFilterBuilder(ExternalDatasetProjectionFiltrationInfo projectionFiltrationInfo, JobGenContext context, IVariableTypeEnvironment typeEnv, ExternalDataPrefix prefix) {
        super(projectionFiltrationInfo.getFilterPaths(), projectionFiltrationInfo.getFilterExpression(), context, typeEnv);
        this.prefix = prefix;
        this.embedFilterValues = projectionFiltrationInfo.isEmbedFilterValues();
    }

    public IExternalFilterEvaluatorFactory build() throws AlgebricksException {
        IScalarEvaluatorFactory evalFactory = null;
        if (this.filterExpression != null && !this.filterPaths.isEmpty()) {
            evalFactory = this.createEvaluator(this.filterExpression);
        }
        if (evalFactory == null && !this.embedFilterValues) {
            return NoOpExternalFilterEvaluatorFactory.INSTANCE;
        }
        List fieldPaths = this.prefix.getComputedFieldNames();
        int numberOfComputedFields = fieldPaths.size();
        ArrayList<ProjectionFiltrationTypeUtil.RenamedType> leafs = new ArrayList<ProjectionFiltrationTypeUtil.RenamedType>(numberOfComputedFields);
        ARecordType previousType = ProjectionFiltrationTypeUtil.EMPTY_TYPE;
        for (int i = 0; i < numberOfComputedFields; ++i) {
            ProjectionFiltrationTypeUtil.RenamedType renamedType = ProjectionFiltrationTypeUtil.renameType((IAType)BuiltinType.ANY, (int)i);
            leafs.add(renamedType);
            List<String> path = Arrays.asList(((String)fieldPaths.get(i)).split("\\."));
            previousType = ProjectionFiltrationTypeUtil.getMergedPathRecordType((ARecordType)previousType, path, (IAType)renamedType);
        }
        return new ExternalFilterEvaluatorFactory(evalFactory, previousType, leafs, this.prefix, this.embedFilterValues);
    }

    @Override
    protected IScalarEvaluatorFactory createValueAccessor(ILogicalExpression expression) {
        ARecordType path = (ARecordType)this.filterPaths.get(expression);
        int index = this.prefix.getPaths().indexOf(path);
        return new ExternalFilterValueEvaluatorFactory(index, (IAType)this.prefix.getComputedFieldTypes().get(index));
    }
}

