/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.app.nc.IndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;

public class IndexCheckpointManagerProvider
implements IIndexCheckpointManagerProvider {
    private final Map<ResourceReference, IndexCheckpointManager> indexCheckpointManagerMap = new HashMap<ResourceReference, IndexCheckpointManager>();
    private final IIOManager ioManager;

    public IndexCheckpointManagerProvider(IIOManager ioManager) {
        this.ioManager = ioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndexCheckpointManager get(ResourceReference ref) throws HyracksDataException {
        Map<ResourceReference, IndexCheckpointManager> map = this.indexCheckpointManagerMap;
        synchronized (map) {
            return this.indexCheckpointManagerMap.computeIfAbsent(ref, this::create);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ResourceReference ref) {
        Map<ResourceReference, IndexCheckpointManager> map = this.indexCheckpointManagerMap;
        synchronized (map) {
            this.indexCheckpointManagerMap.remove(ref);
        }
    }

    private IndexCheckpointManager create(ResourceReference ref) {
        try {
            FileReference indexPath = StoragePathUtil.getIndexPath((IIOManager)this.ioManager, (ResourceReference)ref);
            return new IndexCheckpointManager(indexPath, this.ioManager);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }
}

