/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.MapOGCStructure;
import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromGeoJson;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.geo.evaluators.GeoFunctionTypeInferers;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ParseGeoJSONDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ParseGeoJSONDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return new GeoFunctionTypeInferers.GeometryConstructorTypeInferer();
        }
    };
    private static final long serialVersionUID = 1L;
    private ARecordType recType;

    public void setImmutableStates(Object ... states) {
        this.recType = (ARecordType)states[0];
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.GEOMETRY_CONSTRUCTOR;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ParseGeoJSONEvaluator(args[0], ctx);
            }
        };
    }

    private class ParseGeoJSONEvaluator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg = new VoidPointable();
        private IScalarEvaluator eval;
        private OperatorImportFromGeoJson geoJsonImporter;

        public ParseGeoJSONEvaluator(IScalarEvaluatorFactory factory, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval = factory.createScalarEvaluator(ctx);
            this.geoJsonImporter = OperatorImportFromGeoJson.local();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval.evaluate(tuple, this.inputArg);
            byte[] data = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (data[offset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                throw new TypeMismatchException(ParseGeoJSONDescriptor.this.sourceLoc, BuiltinFunctions.GEOMETRY_CONSTRUCTOR, 0, data[offset], new byte[]{ATypeTag.SERIALIZED_RECORD_TYPE_TAG});
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(data, offset + 1, len - 1);
            DataInputStream dataIn = new DataInputStream(inStream);
            try {
                String geometry = this.recordToString(new ARecordSerializerDeserializer(ParseGeoJSONDescriptor.this.recType).deserialize((DataInput)dataIn));
                MapOGCStructure structure = this.geoJsonImporter.executeOGC(0, geometry, null);
                OGCGeometry ogcGeometry = OGCGeometry.createFromOGCStructure((OGCStructure)structure.m_ogcStructure, (SpatialReference)structure.m_spatialReference);
                ByteBuffer buffer = ogcGeometry.asBinary();
                byte[] wKBGeometryBuffer = buffer.array();
                this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                this.out.writeInt(wKBGeometryBuffer.length);
                this.out.write(wKBGeometryBuffer);
                result.set((IValueReference)this.resultStorage);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(ParseGeoJSONDescriptor.this.sourceLoc, ParseGeoJSONDescriptor.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
        }

        public String recordToString(ARecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            String[] fieldNames = record.getType().getFieldNames();
            if (fieldNames != null) {
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append("\"").append(fieldNames[i]).append("\"").append(": ");
                    IAObject val = record.getValueByPos(i);
                    if (val instanceof ARecord) {
                        sb.append(this.recordToString((ARecord)val));
                        continue;
                    }
                    if (val instanceof AOrderedList) {
                        sb.append(this.listToString((AOrderedList)val));
                        continue;
                    }
                    sb.append(val);
                }
            }
            sb.append(" }");
            return sb.toString();
        }

        public String listToString(AOrderedList list) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("[ ");
            for (int i = 0; i < list.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                IAObject val = list.getItem(i);
                if (val instanceof ARecord) {
                    sb.append(this.recordToString((ARecord)val));
                    continue;
                }
                if (val instanceof AOrderedList) {
                    sb.append(this.listToString((AOrderedList)val));
                    continue;
                }
                sb.append(val);
            }
            sb.append(" ]");
            return sb.toString();
        }
    }
}

