/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class DisconnectFeedStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final Identifier feedName;
    private final Identifier datasetName;

    public DisconnectFeedStatement(Pair<Namespace, Identifier> feedNameComponent, Pair<Namespace, Identifier> datasetNameComponent) {
        if (feedNameComponent.first != null && datasetNameComponent.first != null && !((Namespace)feedNameComponent.first).equals(datasetNameComponent.first)) {
            throw new IllegalArgumentException("Dataverse for source feed and target dataset do not match");
        }
        this.namespace = feedNameComponent.first != null ? (Namespace)feedNameComponent.first : (Namespace)datasetNameComponent.first;
        this.datasetName = (Identifier)datasetNameComponent.second;
        this.feedName = (Identifier)feedNameComponent.second;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public Identifier getFeedName() {
        return this.feedName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.DISCONNECT_FEED;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "disconnect feed " + this.feedName + " from " + this.datasetName;
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

