/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.util.List;
import java.util.Set;
import org.apache.asterix.common.cloud.IPartitionBootstrapper;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalPartitionBootstrapper
implements IPartitionBootstrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIOManager ioManager;

    public LocalPartitionBootstrapper(IIOManager ioManager) {
        this.ioManager = ioManager;
    }

    public IRecoveryManager.SystemState getSystemStateOnMissingCheckpoint() {
        LOGGER.info("The checkpoint file doesn't exist: systemState = PERMANENT_DATA_LOSS");
        return IRecoveryManager.SystemState.PERMANENT_DATA_LOSS;
    }

    public void bootstrap(Set<Integer> activePartitions, List<FileReference> currentOnDiskPartitions, boolean metadataNode, int metadataPartition, boolean cleanup) throws HyracksDataException {
        for (FileReference onDiskPartition : currentOnDiskPartitions) {
            int partitionNum = StoragePathUtil.getPartitionNumFromRelativePath((String)onDiskPartition.getAbsolutePath());
            if (activePartitions.contains(partitionNum)) continue;
            LOGGER.warn("deleting partition {} since it is not on partitions to keep {}", (Object)partitionNum, activePartitions);
            this.ioManager.delete(onDiskPartition);
        }
    }
}

