/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.aws.s3;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3ClientUtils {
    private S3ClientUtils() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static List<S3Object> listS3Objects(S3Client s3Client, String bucket, String path) {
        String newMarker = null;
        ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(bucket);
        listObjectsBuilder.prefix(S3ClientUtils.toCloudPrefix(path));
        ArrayList<S3Object> files = new ArrayList<S3Object>();
        while (true) {
            ListObjectsV2Response listObjectsResponse = newMarker == null ? s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()) : s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.continuationToken(newMarker).build());
            files.addAll(listObjectsResponse.contents());
            if (Boolean.FALSE.equals(listObjectsResponse.isTruncated())) break;
            newMarker = listObjectsResponse.nextContinuationToken();
        }
        return files;
    }

    public static boolean isEmptyPrefix(S3Client s3Client, String bucket, String path) {
        ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(bucket);
        listObjectsBuilder.prefix(S3ClientUtils.toCloudPrefix(path));
        List files = s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()).contents();
        return S3ClientUtils.isEmptyFolder(files, path);
    }

    public static String encodeURI(String path) {
        if (path.isEmpty()) {
            return path;
        }
        try {
            return new URI("s3", "//", path).getRawFragment();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decodeURI(String path) {
        return URLDecoder.decode(path, Charset.defaultCharset());
    }

    private static String toCloudPrefix(String path) {
        return path.startsWith(File.separator) ? path.substring(1) : path;
    }

    private static boolean isEmptyFolder(List<S3Object> files, String path) {
        if (files.size() > 1) {
            return false;
        }
        if (files.isEmpty()) {
            return true;
        }
        S3Object s3Object = files.get(0);
        String key = s3Object.key();
        return s3Object.size() == 0L && key.charAt(key.length() - 1) == '/' && key.startsWith(path);
    }
}

