/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.EnforcePushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.ProfiledPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.std.EmptyTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.EnforceFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.profiling.IOperatorStats;

public class PipelineAssembler {
    private final RecordDescriptor pipelineInputRecordDescriptor;
    private final RecordDescriptor pipelineOutputRecordDescriptor;
    private final int inputArity;
    private final int outputArity;
    private final AlgebricksPipeline pipeline;
    private final Map<IPushRuntimeFactory, IPushRuntime[]> runtimeMap;

    public PipelineAssembler(AlgebricksPipeline pipeline, int inputArity, int outputArity, RecordDescriptor pipelineInputRecordDescriptor, RecordDescriptor pipelineOutputRecordDescriptor) {
        this.pipeline = pipeline;
        this.pipelineInputRecordDescriptor = pipelineInputRecordDescriptor;
        this.pipelineOutputRecordDescriptor = pipelineOutputRecordDescriptor;
        this.inputArity = inputArity;
        this.outputArity = outputArity;
        this.runtimeMap = new HashMap<IPushRuntimeFactory, IPushRuntime[]>();
    }

    public IFrameWriter assemblePipeline(IFrameWriter writer, IHyracksTaskContext ctx) throws HyracksDataException {
        return this.assemblePipeline(writer, ctx, new HashMap<IPushRuntimeFactory, IOperatorStats>());
    }

    public IFrameWriter assemblePipeline(IFrameWriter writer, IHyracksTaskContext ctx, Map<IPushRuntimeFactory, IOperatorStats> microOpStats) throws HyracksDataException {
        boolean enforce = ctx.getJobFlags().contains(JobFlag.ENFORCE_CONTRACT);
        boolean profile = ctx.getJobFlags().contains(JobFlag.PROFILE_RUNTIME);
        IFrameWriter start = writer;
        IPushRuntimeFactory[] runtimeFactories = this.pipeline.getRuntimeFactories();
        RecordDescriptor[] recordDescriptors = this.pipeline.getRecordDescriptors();
        for (int i = runtimeFactories.length - 1; i >= 0; --i) {
            start = enforce && !profile ? EnforceFrameWriter.enforce((IFrameWriter)start) : start;
            IPushRuntimeFactory runtimeFactory = runtimeFactories[i];
            IPushRuntime[] newRuntimes = runtimeFactory.createPushRuntime(ctx);
            for (int j = 0; j < newRuntimes.length; ++j) {
                boolean shouldProfile;
                boolean bl = shouldProfile = profile && !(runtimeFactory instanceof EmptyTupleSourceRuntimeFactory) && microOpStats.containsKey(runtimeFactory);
                if (shouldProfile) {
                    ProfiledPushRuntime profiled = j == 0 ? (ProfiledPushRuntime)ProfiledPushRuntime.time(newRuntimes[j], microOpStats.get(runtimeFactory)) : (ProfiledPushRuntime)ProfiledPushRuntime.time(newRuntimes[j], microOpStats.get(runtimeFactory), false);
                    newRuntimes[j] = profiled;
                } else if (enforce && !profile) {
                    newRuntimes[j] = EnforcePushRuntime.enforce(newRuntimes[j]);
                }
                if (i == runtimeFactories.length - 1) {
                    if (this.outputArity != 1) continue;
                    newRuntimes[j].setOutputFrameWriter(0, start, this.pipelineOutputRecordDescriptor);
                    continue;
                }
                newRuntimes[j].setOutputFrameWriter(0, start, recordDescriptors[i]);
            }
            this.runtimeMap.put(runtimeFactory, newRuntimes);
            IPushRuntime newRuntime = newRuntimes[0];
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[i - 1]);
            } else if (this.inputArity > 0) {
                newRuntime.setInputRecordDescriptor(0, this.pipelineInputRecordDescriptor);
            }
            start = newRuntime;
        }
        return start;
    }

    public IPushRuntime[] getPushRuntime(IPushRuntimeFactory runtimeFactory) {
        return this.runtimeMap.get(runtimeFactory);
    }

    public static IFrameWriter assemblePipeline(AlgebricksPipeline subplan, IFrameWriter writer, IHyracksTaskContext ctx, Map<IPushRuntimeFactory, IPushRuntime> outRuntimeMap) throws HyracksDataException {
        boolean enforce = ctx.getJobFlags().contains(JobFlag.ENFORCE_CONTRACT);
        boolean profile = ctx.getJobFlags().contains(JobFlag.PROFILE_RUNTIME);
        IFrameWriter start = writer;
        IPushRuntimeFactory[] runtimeFactories = subplan.getRuntimeFactories();
        RecordDescriptor[] recordDescriptors = subplan.getRecordDescriptors();
        for (int i = runtimeFactories.length - 1; i >= 0; --i) {
            start = enforce && !profile ? EnforceFrameWriter.enforce((IFrameWriter)start) : start;
            IPushRuntimeFactory runtimeFactory = runtimeFactories[i];
            IPushRuntime[] newRuntimes = runtimeFactory.createPushRuntime(ctx);
            IPushRuntime newRuntime = enforce ? EnforcePushRuntime.enforce(newRuntimes[0]) : newRuntimes[0];
            newRuntime.setOutputFrameWriter(0, start, recordDescriptors[i]);
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[i - 1]);
            } else {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[0]);
            }
            if (outRuntimeMap != null) {
                outRuntimeMap.put(runtimeFactory, newRuntimes[0]);
            }
            start = newRuntime;
        }
        return start;
    }

    public static IPushRuntime linkPipeline(AlgebricksPipeline pipeline, PipelineAssembler[] pipelineAssemblers, int pipelineAssemblersCount) throws HyracksDataException {
        IPushRuntimeFactory[] outputRuntimeFactories = pipeline.getOutputRuntimeFactories();
        if (outputRuntimeFactories == null || outputRuntimeFactories.length != 1) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"No output runtime factories found."});
        }
        IPushRuntimeFactory outRuntimeFactory = outputRuntimeFactories[0];
        int outputPosition = pipeline.getOutputPositions()[0];
        for (int i = 0; i < pipelineAssemblersCount; ++i) {
            IPushRuntime[] p = pipelineAssemblers[i].getPushRuntime(outRuntimeFactory);
            if (p == null) continue;
            return p[outputPosition];
        }
        return null;
    }
}

