/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;

public class MetadataUtil {
    public static final int PENDING_NO_OP = 0;
    public static final int PENDING_ADD_OP = 1;
    public static final int PENDING_DROP_OP = 2;

    private MetadataUtil() {
    }

    public static String pendingOpToString(int pendingOp) {
        switch (pendingOp) {
            case 0: {
                return "Pending No Operation";
            }
            case 1: {
                return "Pending Add Operation";
            }
            case 2: {
                return "Pending Drop Operation";
            }
        }
        return "Unknown Pending Operation";
    }

    public static String dataverseName(String databaseName, DataverseName dataverseName, boolean useDb) {
        return useDb ? databaseName + "." + dataverseName : String.valueOf(dataverseName);
    }

    public static String getFullyQualifiedDisplayName(DataverseName dataverseName, String objectName) {
        return dataverseName + "." + objectName;
    }

    public static String getFullyQualifiedDisplayName(String databaseName, DataverseName dataverseName, String objectName) {
        return databaseName + "." + dataverseName + "." + objectName;
    }

    public static String databaseFor(DataverseName dataverse) {
        if (dataverse == null) {
            return null;
        }
        if (MetadataConstants.METADATA_DATAVERSE_NAME.equals(dataverse)) {
            return "System";
        }
        if (FunctionConstants.ASTERIX_DV.equals(dataverse)) {
            return "asterix";
        }
        if (FunctionConstants.ALGEBRICKS_DV.equals(dataverse)) {
            return "algebricks";
        }
        return "Default";
    }

    public static String resolveDatabase(String database, DataverseName dataverse) {
        if (dataverse == null) {
            return null;
        }
        if (database != null) {
            return database;
        }
        return MetadataUtil.databaseFor(dataverse);
    }
}

