/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils2.PropertyUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira357Test {
    private void checkReadMethod(String propertyName, Class<?> expectedDeclaringClass) throws Exception {
        PropertyDescriptor[] descriptors = null;
        descriptors = PropertyUtils.getPropertyDescriptors(ConcreteTestBean.class);
        PropertyDescriptor descriptor = this.findDescriptor(propertyName, descriptors);
        Assertions.assertNotNull((Object)descriptor, (String)(propertyName + "descriptor"));
        Assertions.assertEquals(expectedDeclaringClass, descriptor.getReadMethod().getDeclaringClass(), (String)(propertyName + " read method declaring class"));
    }

    private PropertyDescriptor findDescriptor(String propertyName, PropertyDescriptor[] descriptors) {
        if (descriptors != null) {
            for (PropertyDescriptor descriptor : descriptors) {
                if (!propertyName.equals(descriptor.getName())) continue;
                return descriptor;
            }
        }
        return null;
    }

    @BeforeEach
    protected void setUp() throws Exception {
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testPropertyUtils_getPropertyDescriptors_Bar() throws Exception {
        this.checkReadMethod("bar", ConcreteTestBean.class);
    }

    @Test
    public void testPropertyUtils_getPropertyDescriptors_Foo() throws Exception {
        this.checkReadMethod("foo", ConcreteTestBean.class);
    }

    @Test
    public void testPropertyUtils_getPropertyDescriptors_InnerClassProperty() throws Exception {
        this.checkReadMethod("innerClassProperty", ConcreteTestBean.class);
    }

    public static class ConcreteTestBean
    extends AbstractTestBean {
        private String foo;
        private boolean bar;
        private AbstractTestBean.InnerClass innerClassProperty;

        @Override
        public String getFoo() {
            return this.foo;
        }

        @Override
        public AbstractTestBean.InnerClass getInnerClassProperty() {
            return this.innerClassProperty;
        }

        @Override
        public boolean isBar() {
            return this.bar;
        }

        @Override
        public void setBar(boolean bar) {
            this.bar = bar;
        }

        @Override
        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void setInnerClassProperty(AbstractTestBean.InnerClass innerClassProperty) {
            this.innerClassProperty = innerClassProperty;
        }
    }

    public static abstract class AbstractTestBean {
        public abstract String getFoo();

        public abstract InnerClass getInnerClassProperty();

        public abstract boolean isBar();

        public abstract void setBar(boolean var1);

        public abstract void setFoo(String var1);

        public static abstract class InnerClass {
            private String firstName;

            public String getInnerName() {
                return this.firstName;
            }

            public void setInnerName(String firstName) {
                this.firstName = firstName;
            }
        }
    }
}

