/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.function.StepFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.junit.Assert;
import org.junit.Test;

public class StepFunctionTest {
    private final double EPS = Math.ulp(1.0);

    @Test(expected=NullArgumentException.class)
    public void testPreconditions1() {
        new StepFunction(null, new double[]{0.0, -1.0, -2.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testPreconditions2() {
        new StepFunction(new double[]{0.0, 1.0}, null);
    }

    @Test(expected=NoDataException.class)
    public void testPreconditions3() {
        new StepFunction(new double[]{0.0}, new double[0]);
    }

    @Test(expected=NoDataException.class)
    public void testPreconditions4() {
        new StepFunction(new double[0], new double[]{0.0});
    }

    @Test(expected=DimensionMismatchException.class)
    public void testPreconditions5() {
        new StepFunction(new double[]{0.0, 1.0}, new double[]{0.0, -1.0, -2.0});
    }

    @Test(expected=NonMonotonicSequenceException.class)
    public void testPreconditions6() {
        new StepFunction(new double[]{1.0, 0.0, 1.0}, new double[]{0.0, -1.0, -2.0});
    }

    @Test
    public void testSomeValues() {
        double[] x = new double[]{-2.0, -0.5, 0.0, 1.9, 7.4, 21.3};
        double[] y = new double[]{4.0, -1.0, -5.5, 0.4, 5.8, 51.2};
        StepFunction f = new StepFunction(x, y);
        Assert.assertEquals((double)4.0, (double)f.value(Double.NEGATIVE_INFINITY), (double)this.EPS);
        Assert.assertEquals((double)4.0, (double)f.value(-10.0), (double)this.EPS);
        Assert.assertEquals((double)-1.0, (double)f.value(-0.4), (double)this.EPS);
        Assert.assertEquals((double)-5.5, (double)f.value(0.0), (double)this.EPS);
        Assert.assertEquals((double)0.4, (double)f.value(2.0), (double)this.EPS);
        Assert.assertEquals((double)5.8, (double)f.value(10.0), (double)this.EPS);
        Assert.assertEquals((double)51.2, (double)f.value(30.0), (double)this.EPS);
        Assert.assertEquals((double)51.2, (double)f.value(Double.POSITIVE_INFINITY), (double)this.EPS);
    }

    @Test
    public void testEndpointBehavior() {
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] xp = new double[]{-8.0, 1.0, 2.0, 3.0};
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        StepFunction f = new StepFunction(x, y);
        StepFunction fp = new StepFunction(xp, y);
        Assert.assertEquals((double)f.value(-8.0), (double)fp.value(-8.0), (double)this.EPS);
        Assert.assertEquals((double)f.value(-10.0), (double)fp.value(-10.0), (double)this.EPS);
        Assert.assertEquals((double)f.value(0.0), (double)fp.value(0.0), (double)this.EPS);
        Assert.assertEquals((double)f.value(0.5), (double)fp.value(0.5), (double)this.EPS);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)y[i], (double)f.value(x[i]), (double)this.EPS);
            if (i > 0) {
                Assert.assertEquals((double)y[i - 1], (double)f.value(x[i] - 0.5), (double)this.EPS);
                continue;
            }
            Assert.assertEquals((double)y[0], (double)f.value(x[i] - 0.5), (double)this.EPS);
        }
    }

    @Test
    public void testHeaviside() {
        StepFunction h = new StepFunction(new double[]{-1.0, 0.0}, new double[]{0.0, 1.0});
        Assert.assertEquals((double)0.0, (double)h.value(Double.NEGATIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)0.0, (double)h.value(-1.7976931348623157E308), (double)0.0);
        Assert.assertEquals((double)0.0, (double)h.value(-2.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)h.value(-4.9E-324), (double)0.0);
        Assert.assertEquals((double)1.0, (double)h.value(0.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)h.value(2.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)h.value(Double.POSITIVE_INFINITY), (double)0.0);
    }
}

