/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.fraction.FractionField;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.SparseFieldMatrix;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFieldMatrixTest {
    protected Fraction[][] id = new Fraction[][]{{new Fraction(1), new Fraction(0), new Fraction(0)}, {new Fraction(0), new Fraction(1), new Fraction(0)}, {new Fraction(0), new Fraction(0), new Fraction(1)}};
    protected Fraction[][] testData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(1), new Fraction(0), new Fraction(8)}};
    protected Fraction[][] testDataLU = null;
    protected Fraction[][] testDataPlus2 = new Fraction[][]{{new Fraction(3), new Fraction(4), new Fraction(5)}, {new Fraction(4), new Fraction(7), new Fraction(5)}, {new Fraction(3), new Fraction(2), new Fraction(10)}};
    protected Fraction[][] testDataMinus = new Fraction[][]{{new Fraction(-1), new Fraction(-2), new Fraction(-3)}, {new Fraction(-2), new Fraction(-5), new Fraction(-3)}, {new Fraction(-1), new Fraction(0), new Fraction(-8)}};
    protected Fraction[] testDataRow1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] testDataCol3 = new Fraction[]{new Fraction(3), new Fraction(3), new Fraction(8)};
    protected Fraction[][] testDataInv = new Fraction[][]{{new Fraction(-40), new Fraction(16), new Fraction(9)}, {new Fraction(13), new Fraction(-5), new Fraction(-3)}, {new Fraction(5), new Fraction(-2), new Fraction(-1)}};
    protected Fraction[] preMultTest = new Fraction[]{new Fraction(8), new Fraction(12), new Fraction(33)};
    protected Fraction[][] testData2 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}};
    protected Fraction[][] testData2T = new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(2), new Fraction(5)}, {new Fraction(3), new Fraction(3)}};
    protected Fraction[][] testDataPlusInv = new Fraction[][]{{new Fraction(-39), new Fraction(18), new Fraction(12)}, {new Fraction(15), new Fraction(0), new Fraction(0)}, {new Fraction(6), new Fraction(-2), new Fraction(7)}};
    protected Fraction[][] luData = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(3)}, {new Fraction(0), new Fraction(5), new Fraction(7)}, {new Fraction(6), new Fraction(9), new Fraction(8)}};
    protected Fraction[][] luDataLUDecomposition = null;
    protected Fraction[][] singular = new Fraction[][]{{new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(3)}};
    protected Fraction[][] bigSingular = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(2), new Fraction(5), new Fraction(3), new Fraction(4)}, {new Fraction(7), new Fraction(3), new Fraction(256), new Fraction(1930)}, {new Fraction(3), new Fraction(7), new Fraction(6), new Fraction(8)}};
    protected Fraction[][] detData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(10)}};
    protected Fraction[][] detData2 = new Fraction[][]{{new Fraction(1), new Fraction(3)}, {new Fraction(2), new Fraction(4)}};
    protected Fraction[] testVector = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] testVector2 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)};
    protected Fraction[][] subTestData = null;
    protected Fraction[][] subRows02Cols13 = new Fraction[][]{{new Fraction(2), new Fraction(4)}, {new Fraction(4), new Fraction(8)}};
    protected Fraction[][] subRows03Cols12 = new Fraction[][]{{new Fraction(2), new Fraction(3)}, {new Fraction(5), new Fraction(6)}};
    protected Fraction[][] subRows03Cols123 = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6), new Fraction(7)}};
    protected Fraction[][] subRows20Cols123 = new Fraction[][]{{new Fraction(4), new Fraction(6), new Fraction(8)}, {new Fraction(2), new Fraction(3), new Fraction(4)}};
    protected Fraction[][] subRows31Cols31 = null;
    protected Fraction[][] subRows01Cols23 = null;
    protected Fraction[][] subRows23Cols00 = new Fraction[][]{{new Fraction(2)}, {new Fraction(4)}};
    protected Fraction[][] subRows00Cols33 = new Fraction[][]{{new Fraction(4)}};
    protected Fraction[][] subRow0 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}};
    protected Fraction[][] subRow3 = new Fraction[][]{{new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7)}};
    protected Fraction[][] subColumn1 = null;
    protected Fraction[][] subColumn3 = null;
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    protected Field<Fraction> field = FractionField.getInstance();
    private Fraction[][] d3 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8)}};
    private Fraction[][] d4 = new Fraction[][]{{new Fraction(1)}, {new Fraction(2)}, {new Fraction(3)}, {new Fraction(4)}};
    private Fraction[][] d5 = new Fraction[][]{{new Fraction(30)}, {new Fraction(70)}};

    public SparseFieldMatrixTest() {
        try {
            this.testDataLU = new Fraction[][]{{new Fraction(2), new Fraction(5), new Fraction(3)}, {new Fraction(0.5), new Fraction(-2.5), new Fraction(6.5)}, {new Fraction(0.5), new Fraction(0.2), new Fraction(0.2)}};
            this.luDataLUDecomposition = new Fraction[][]{{new Fraction(6), new Fraction(9), new Fraction(8)}, {new Fraction(0), new Fraction(5), new Fraction(7)}, {new Fraction(0.33333333333333), new Fraction(0), new Fraction(0.33333333333333)}};
            this.subTestData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(1.5), new Fraction(2.5), new Fraction(3.5), new Fraction(4.5)}, {new Fraction(2), new Fraction(4), new Fraction(6), new Fraction(8)}, {new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7)}};
            this.subRows31Cols31 = new Fraction[][]{{new Fraction(7), new Fraction(5)}, {new Fraction(4.5), new Fraction(2.5)}};
            this.subRows01Cols23 = new Fraction[][]{{new Fraction(3), new Fraction(4)}, {new Fraction(3.5), new Fraction(4.5)}};
            this.subColumn1 = new Fraction[][]{{new Fraction(2)}, {new Fraction(2.5)}, {new Fraction(4)}, {new Fraction(5)}};
            this.subColumn3 = new Fraction[][]{{new Fraction(4)}, {new Fraction(4.5)}, {new Fraction(8)}, {new Fraction(7)}};
        }
        catch (FractionConversionException fractionConversionException) {
            // empty catch block
        }
    }

    @Test
    public void testDimensions() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> m2 = this.createSparseMatrix(this.testData2);
        Assert.assertEquals((String)"testData row dimension", (long)3L, (long)m.getRowDimension());
        Assert.assertEquals((String)"testData column dimension", (long)3L, (long)m.getColumnDimension());
        Assert.assertTrue((String)"testData is square", (boolean)m.isSquare());
        Assert.assertEquals((String)"testData2 row dimension", (long)m2.getRowDimension(), (long)2L);
        Assert.assertEquals((String)"testData2 column dimension", (long)m2.getColumnDimension(), (long)3L);
        Assert.assertTrue((String)"testData2 is not square", (!m2.isSquare() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFunctions() {
        SparseFieldMatrix<Fraction> m1 = this.createSparseMatrix(this.testData);
        FieldMatrix m2 = m1.copy();
        Assert.assertEquals(m1.getClass(), m2.getClass());
        Assert.assertEquals((Object)m2, m1);
        SparseFieldMatrix<Fraction> m3 = this.createSparseMatrix(this.testData);
        FieldMatrix m4 = m3.copy();
        Assert.assertEquals(m3.getClass(), m4.getClass());
        Assert.assertEquals((Object)m4, m3);
    }

    @Test
    public void testAdd() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> mInv = this.createSparseMatrix(this.testDataInv);
        SparseFieldMatrix<Fraction> mDataPlusInv = this.createSparseMatrix(this.testDataPlusInv);
        FieldMatrix mPlusMInv = m.add(mInv);
        for (int row = 0; row < m.getRowDimension(); ++row) {
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                Assert.assertEquals((String)"sum entry entry", (double)((Fraction)mDataPlusInv.getEntry(row, col)).doubleValue(), (double)((Fraction)mPlusMInv.getEntry(row, col)).doubleValue(), (double)this.entryTolerance);
            }
        }
    }

    @Test
    public void testAddFail() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> m2 = this.createSparseMatrix(this.testData2);
        try {
            m.add(m2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPlusMinus() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> n = this.createSparseMatrix(this.testDataInv);
        this.assertClose("m-n = m + -n", (FieldMatrix<Fraction>)m.subtract(n), (FieldMatrix<Fraction>)n.scalarMultiply((FieldElement)new Fraction(-1)).add(m), this.entryTolerance);
        try {
            m.subtract(this.createSparseMatrix(this.testData2));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> mInv = this.createSparseMatrix(this.testDataInv);
        SparseFieldMatrix<Fraction> identity = this.createSparseMatrix(this.id);
        SparseFieldMatrix<Fraction> m2 = this.createSparseMatrix(this.testData2);
        this.assertClose("inverse multiply", (FieldMatrix<Fraction>)m.multiply(mInv), (FieldMatrix<Fraction>)identity, this.entryTolerance);
        this.assertClose("inverse multiply", (FieldMatrix<Fraction>)m.multiply((FieldMatrix)new Array2DRowFieldMatrix((Field)FractionField.getInstance(), (FieldElement[][])this.testDataInv)), (FieldMatrix<Fraction>)identity, this.entryTolerance);
        this.assertClose("inverse multiply", (FieldMatrix<Fraction>)mInv.multiply(m), (FieldMatrix<Fraction>)identity, this.entryTolerance);
        this.assertClose("identity multiply", (FieldMatrix<Fraction>)m.multiply(identity), (FieldMatrix<Fraction>)m, this.entryTolerance);
        this.assertClose("identity multiply", (FieldMatrix<Fraction>)identity.multiply(mInv), (FieldMatrix<Fraction>)mInv, this.entryTolerance);
        this.assertClose("identity multiply", (FieldMatrix<Fraction>)m2.multiply(identity), (FieldMatrix<Fraction>)m2, this.entryTolerance);
        try {
            m.multiply(this.createSparseMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply2() {
        SparseFieldMatrix<Fraction> m3 = this.createSparseMatrix(this.d3);
        SparseFieldMatrix<Fraction> m4 = this.createSparseMatrix(this.d4);
        SparseFieldMatrix<Fraction> m5 = this.createSparseMatrix(this.d5);
        this.assertClose("m3*m4=m5", (FieldMatrix<Fraction>)m3.multiply(m4), (FieldMatrix<Fraction>)m5, this.entryTolerance);
    }

    @Test
    public void testTrace() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.id);
        Assert.assertEquals((String)"identity trace", (double)3.0, (double)((Fraction)m.getTrace()).doubleValue(), (double)this.entryTolerance);
        m = this.createSparseMatrix(this.testData2);
        try {
            m.getTrace();
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testScalarAdd() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        this.assertClose("scalar add", (FieldMatrix<Fraction>)this.createSparseMatrix(this.testDataPlus2), (FieldMatrix<Fraction>)m.scalarAdd((FieldElement)new Fraction(2)), this.entryTolerance);
    }

    @Test
    public void testOperate() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.id);
        this.assertClose("identity operate", this.testVector, (Fraction[])m.operate((FieldElement[])this.testVector), this.entryTolerance);
        this.assertClose("identity operate", this.testVector, (Fraction[])m.operate((FieldVector)new ArrayFieldVector((FieldElement[])this.testVector)).toArray(), this.entryTolerance);
        m = this.createSparseMatrix(this.bigSingular);
        try {
            m.operate((FieldElement[])this.testVector);
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMath209() {
        SparseFieldMatrix<Fraction> a = this.createSparseMatrix(new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6)}});
        Fraction[] b = (Fraction[])a.operate((FieldElement[])new Fraction[]{new Fraction(1), new Fraction(1)});
        Assert.assertEquals((long)a.getRowDimension(), (long)b.length);
        Assert.assertEquals((double)3.0, (double)b[0].doubleValue(), (double)1.0E-12);
        Assert.assertEquals((double)7.0, (double)b[1].doubleValue(), (double)1.0E-12);
        Assert.assertEquals((double)11.0, (double)b[2].doubleValue(), (double)1.0E-12);
    }

    @Test
    public void testTranspose() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        FieldMatrix mIT = new FieldLUDecomposition(m).getSolver().getInverse().transpose();
        FieldMatrix mTI = new FieldLUDecomposition(m.transpose()).getSolver().getInverse();
        this.assertClose("inverse-transpose", (FieldMatrix<Fraction>)mIT, (FieldMatrix<Fraction>)mTI, this.normTolerance);
        m = this.createSparseMatrix(this.testData2);
        SparseFieldMatrix<Fraction> mt = this.createSparseMatrix(this.testData2T);
        this.assertClose("transpose", (FieldMatrix<Fraction>)mt, (FieldMatrix<Fraction>)m.transpose(), this.normTolerance);
    }

    @Test
    public void testPremultiplyVector() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        this.assertClose("premultiply", (Fraction[])m.preMultiply((FieldElement[])this.testVector), this.preMultTest, this.normTolerance);
        this.assertClose("premultiply", (Fraction[])m.preMultiply(new ArrayFieldVector((FieldElement[])this.testVector).getData()), this.preMultTest, this.normTolerance);
        m = this.createSparseMatrix(this.bigSingular);
        try {
            m.preMultiply((FieldElement[])this.testVector);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPremultiply() {
        SparseFieldMatrix<Fraction> m3 = this.createSparseMatrix(this.d3);
        SparseFieldMatrix<Fraction> m4 = this.createSparseMatrix(this.d4);
        SparseFieldMatrix<Fraction> m5 = this.createSparseMatrix(this.d5);
        this.assertClose("m3*m4=m5", (FieldMatrix<Fraction>)m4.preMultiply(m3), (FieldMatrix<Fraction>)m5, this.entryTolerance);
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix<Fraction> mInv = this.createSparseMatrix(this.testDataInv);
        SparseFieldMatrix<Fraction> identity = this.createSparseMatrix(this.id);
        this.assertClose("inverse multiply", (FieldMatrix<Fraction>)m.preMultiply(mInv), (FieldMatrix<Fraction>)identity, this.entryTolerance);
        this.assertClose("inverse multiply", (FieldMatrix<Fraction>)mInv.preMultiply(m), (FieldMatrix<Fraction>)identity, this.entryTolerance);
        this.assertClose("identity multiply", (FieldMatrix<Fraction>)m.preMultiply(identity), (FieldMatrix<Fraction>)m, this.entryTolerance);
        this.assertClose("identity multiply", (FieldMatrix<Fraction>)identity.preMultiply(mInv), (FieldMatrix<Fraction>)mInv, this.entryTolerance);
        try {
            m.preMultiply(this.createSparseMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetVectors() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        this.assertClose("get row", (Fraction[])m.getRow(0), this.testDataRow1, this.entryTolerance);
        this.assertClose("get col", (Fraction[])m.getColumn(2), this.testDataCol3, this.entryTolerance);
        try {
            m.getRow(10);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(-1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        Assert.assertEquals((String)"get entry", (double)((Fraction)m.getEntry(0, 1)).doubleValue(), (double)2.0, (double)this.entryTolerance);
        try {
            m.getEntry(10, 4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testExamples() {
        Fraction[][] matrixData = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(5), new Fraction(3)}};
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(matrixData);
        Fraction[][] matrixData2 = new Fraction[][]{{new Fraction(1), new Fraction(2)}, {new Fraction(2), new Fraction(5)}, {new Fraction(1), new Fraction(7)}};
        SparseFieldMatrix<Fraction> n = this.createSparseMatrix(matrixData2);
        FieldMatrix p = m.multiply(n);
        Assert.assertEquals((long)2L, (long)p.getRowDimension());
        Assert.assertEquals((long)2L, (long)p.getColumnDimension());
        FieldMatrix pInverse = new FieldLUDecomposition(p).getSolver().getInverse();
        Assert.assertEquals((long)2L, (long)pInverse.getRowDimension());
        Assert.assertEquals((long)2L, (long)pInverse.getColumnDimension());
        Fraction[][] coefficientsData = new Fraction[][]{{new Fraction(2), new Fraction(3), new Fraction(-2)}, {new Fraction(-1), new Fraction(7), new Fraction(6)}, {new Fraction(4), new Fraction(-3), new Fraction(-5)}};
        SparseFieldMatrix<Fraction> coefficients = this.createSparseMatrix(coefficientsData);
        Fraction[] constants = new Fraction[]{new Fraction(1), new Fraction(-2), new Fraction(1)};
        Fraction[] solution = (Fraction[])new FieldLUDecomposition(coefficients).getSolver().solve((FieldVector)new ArrayFieldVector((FieldElement[])constants, false)).toArray();
        Assert.assertEquals((double)new Fraction(2).multiply(solution[0]).add(new Fraction(3).multiply(solution[1])).subtract(new Fraction(2).multiply(solution[2])).doubleValue(), (double)constants[0].doubleValue(), (double)1.0E-12);
        Assert.assertEquals((double)new Fraction(-1).multiply(solution[0]).add(new Fraction(7).multiply(solution[1])).add(new Fraction(6).multiply(solution[2])).doubleValue(), (double)constants[1].doubleValue(), (double)1.0E-12);
        Assert.assertEquals((double)new Fraction(4).multiply(solution[0]).subtract(new Fraction(3).multiply(solution[1])).subtract(new Fraction(5).multiply(solution[2])).doubleValue(), (double)constants[2].doubleValue(), (double)1.0E-12);
    }

    @Test
    public void testSubMatrix() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.subTestData);
        SparseFieldMatrix<Fraction> mRows23Cols00 = this.createSparseMatrix(this.subRows23Cols00);
        SparseFieldMatrix<Fraction> mRows00Cols33 = this.createSparseMatrix(this.subRows00Cols33);
        SparseFieldMatrix<Fraction> mRows01Cols23 = this.createSparseMatrix(this.subRows01Cols23);
        SparseFieldMatrix<Fraction> mRows02Cols13 = this.createSparseMatrix(this.subRows02Cols13);
        SparseFieldMatrix<Fraction> mRows03Cols12 = this.createSparseMatrix(this.subRows03Cols12);
        SparseFieldMatrix<Fraction> mRows03Cols123 = this.createSparseMatrix(this.subRows03Cols123);
        SparseFieldMatrix<Fraction> mRows20Cols123 = this.createSparseMatrix(this.subRows20Cols123);
        SparseFieldMatrix<Fraction> mRows31Cols31 = this.createSparseMatrix(this.subRows31Cols31);
        Assert.assertEquals((String)"Rows23Cols00", mRows23Cols00, (Object)m.getSubMatrix(2, 3, 0, 0));
        Assert.assertEquals((String)"Rows00Cols33", mRows00Cols33, (Object)m.getSubMatrix(0, 0, 3, 3));
        Assert.assertEquals((String)"Rows01Cols23", mRows01Cols23, (Object)m.getSubMatrix(0, 1, 2, 3));
        Assert.assertEquals((String)"Rows02Cols13", mRows02Cols13, (Object)m.getSubMatrix(new int[]{0, 2}, new int[]{1, 3}));
        Assert.assertEquals((String)"Rows03Cols12", mRows03Cols12, (Object)m.getSubMatrix(new int[]{0, 3}, new int[]{1, 2}));
        Assert.assertEquals((String)"Rows03Cols123", mRows03Cols123, (Object)m.getSubMatrix(new int[]{0, 3}, new int[]{1, 2, 3}));
        Assert.assertEquals((String)"Rows20Cols123", mRows20Cols123, (Object)m.getSubMatrix(new int[]{2, 0}, new int[]{1, 2, 3}));
        Assert.assertEquals((String)"Rows31Cols31", mRows31Cols31, (Object)m.getSubMatrix(new int[]{3, 1}, new int[]{3, 1}));
        Assert.assertEquals((String)"Rows31Cols31", mRows31Cols31, (Object)m.getSubMatrix(new int[]{3, 1}, new int[]{3, 1}));
        try {
            m.getSubMatrix(1, 0, 2, 4);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(-1, 1, 2, 2);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(1, 0, 2, 2);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(1, 0, 2, 4);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(new int[0], new int[]{0});
            Assert.fail((String)"Expecting NoDataException");
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(new int[]{0}, new int[]{4});
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowMatrix() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.subTestData);
        SparseFieldMatrix<Fraction> mRow0 = this.createSparseMatrix(this.subRow0);
        SparseFieldMatrix<Fraction> mRow3 = this.createSparseMatrix(this.subRow3);
        Assert.assertEquals((String)"Row0", mRow0, (Object)m.getRowMatrix(0));
        Assert.assertEquals((String)"Row3", mRow3, (Object)m.getRowMatrix(3));
        try {
            m.getRowMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnMatrix() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.subTestData);
        SparseFieldMatrix<Fraction> mColumn1 = this.createSparseMatrix(this.subColumn1);
        SparseFieldMatrix<Fraction> mColumn3 = this.createSparseMatrix(this.subColumn3);
        Assert.assertEquals((String)"Column1", mColumn1, (Object)m.getColumnMatrix(1));
        Assert.assertEquals((String)"Column3", mColumn3, (Object)m.getColumnMatrix(3));
        try {
            m.getColumnMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowVector() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.subTestData);
        ArrayFieldVector mRow0 = new ArrayFieldVector((FieldElement[])this.subRow0[0]);
        ArrayFieldVector mRow3 = new ArrayFieldVector((FieldElement[])this.subRow3[0]);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowVector(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowVector(3));
        try {
            m.getRowVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnVector() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.subTestData);
        FieldVector<Fraction> mColumn1 = this.columnToVector(this.subColumn1);
        FieldVector<Fraction> mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertEquals((String)"Column1", mColumn1, (Object)m.getColumnVector(1));
        Assert.assertEquals((String)"Column3", mColumn3, (Object)m.getColumnVector(3));
        try {
            m.getColumnVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    private FieldVector<Fraction> columnToVector(Fraction[][] column) {
        Fraction[] data = new Fraction[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return new ArrayFieldVector((FieldElement[])data, false);
    }

    @Test
    public void testEqualsAndHashCode() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        SparseFieldMatrix m1 = (SparseFieldMatrix)m.copy();
        SparseFieldMatrix mt = (SparseFieldMatrix)m.transpose();
        Assert.assertTrue((m.hashCode() != mt.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)m.hashCode(), (long)m1.hashCode());
        Assert.assertEquals(m, m);
        Assert.assertEquals(m, (Object)m1);
        Assert.assertFalse((boolean)m.equals(null));
        Assert.assertFalse((boolean)m.equals((Object)mt));
        Assert.assertFalse((boolean)m.equals(this.createSparseMatrix(this.bigSingular)));
    }

    @Test
    public void testSetSubMatrix() {
        SparseFieldMatrix<Fraction> m = this.createSparseMatrix(this.testData);
        m.setSubMatrix((FieldElement[][])this.detData2, 1, 1);
        SparseFieldMatrix<Fraction> expected = this.createSparseMatrix(new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(2), new Fraction(1), new Fraction(3)}, {new Fraction(1), new Fraction(2), new Fraction(4)}});
        Assert.assertEquals(expected, m);
        m.setSubMatrix((FieldElement[][])this.detData2, 0, 0);
        expected = this.createSparseMatrix(new Fraction[][]{{new Fraction(1), new Fraction(3), new Fraction(3)}, {new Fraction(2), new Fraction(4), new Fraction(3)}, {new Fraction(1), new Fraction(2), new Fraction(4)}});
        Assert.assertEquals(expected, m);
        m.setSubMatrix((FieldElement[][])this.testDataPlus2, 0, 0);
        expected = this.createSparseMatrix(new Fraction[][]{{new Fraction(3), new Fraction(4), new Fraction(5)}, {new Fraction(4), new Fraction(7), new Fraction(5)}, {new Fraction(3), new Fraction(2), new Fraction(10)}});
        Assert.assertEquals(expected, m);
        SparseFieldMatrix<Fraction> matrix = this.createSparseMatrix(new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8)}, {new Fraction(9), new Fraction(0), new Fraction(1), new Fraction(2)}});
        matrix.setSubMatrix((FieldElement[][])new Fraction[][]{{new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(6)}}, 1, 1);
        expected = this.createSparseMatrix(new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4)}, {new Fraction(5), new Fraction(3), new Fraction(4), new Fraction(8)}, {new Fraction(9), new Fraction(5), new Fraction(6), new Fraction(2)}});
        Assert.assertEquals(expected, matrix);
        try {
            m.setSubMatrix((FieldElement[][])this.testData, 1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])this.testData, -1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])this.testData, 1, -1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])null, 1, 1);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            new SparseFieldMatrix(this.field, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])new Fraction[][]{{new Fraction(1)}, {new Fraction(2), new Fraction(3)}}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((FieldElement[][])new Fraction[][]{new Fraction[0]}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    protected void assertClose(String msg, FieldMatrix<Fraction> m, FieldMatrix<Fraction> n, double tolerance) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                Assert.assertEquals((String)msg, (double)((Fraction)m.getEntry(i, j)).doubleValue(), (double)((Fraction)n.getEntry(i, j)).doubleValue(), (double)tolerance);
            }
        }
    }

    protected void assertClose(String msg, Fraction[] m, Fraction[] n, double tolerance) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors not same length");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((String)(msg + " " + i + " elements differ"), (double)m[i].doubleValue(), (double)n[i].doubleValue(), (double)tolerance);
        }
    }

    private SparseFieldMatrix<Fraction> createSparseMatrix(Fraction[][] data) {
        SparseFieldMatrix matrix = new SparseFieldMatrix(this.field, data.length, data[0].length);
        for (int row = 0; row < data.length; ++row) {
            for (int col = 0; col < data[row].length; ++col) {
                matrix.setEntry(row, col, (FieldElement)data[row][col]);
            }
        }
        return matrix;
    }
}

