/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.TestFieldProblemAbstract;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFieldProblem1<T extends RealFieldElement<T>>
extends TestFieldProblemAbstract<T> {
    public TestFieldProblem1(Field<T> field) {
        super(field);
        this.setInitialConditions((RealFieldElement)this.convert(0.0), this.convert(new double[]{1.0, 0.1}));
        this.setFinalConditions(this.convert(4.0));
        this.setErrorScale(this.convert(new double[]{1.0, 1.0}));
    }

    @Override
    public T[] doComputeDerivatives(T t, T[] y) {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        for (int i = 0; i < this.getDimension(); ++i) {
            yDot[i] = (RealFieldElement)y[i].negate();
        }
        return yDot;
    }

    @Override
    public T[] computeTheoreticalState(T t) {
        FieldODEState s0 = this.getInitialState();
        RealFieldElement[] y0 = s0.getState();
        RealFieldElement[] y = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)this.getDimension());
        RealFieldElement c = (RealFieldElement)((RealFieldElement)s0.getTime().subtract(t)).exp();
        for (int i = 0; i < this.getDimension(); ++i) {
            y[i] = (RealFieldElement)c.multiply((Object)y0[i]);
        }
        return y;
    }
}

