/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.sampling.DummyStepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class DummyStepInterpolatorTest {
    @Test
    public void testNoReset() throws MaxCountExceededException {
        double[] y = new double[]{0.0, 1.0, -2.0};
        DummyStepInterpolator interpolator = new DummyStepInterpolator(y, new double[y.length], true);
        interpolator.storeTime(0.0);
        interpolator.shift();
        interpolator.storeTime(1.0);
        double[] result = interpolator.getInterpolatedState();
        for (int i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFixedState() throws MaxCountExceededException {
        int i;
        double[] y = new double[]{1.0, 3.0, -4.0};
        DummyStepInterpolator interpolator = new DummyStepInterpolator(y, new double[y.length], true);
        interpolator.storeTime(0.0);
        interpolator.shift();
        interpolator.storeTime(1.0);
        interpolator.setInterpolatedTime(0.1);
        double[] result = interpolator.getInterpolatedState();
        for (i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
        interpolator.setInterpolatedTime(0.5);
        result = interpolator.getInterpolatedState();
        for (i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException, MaxCountExceededException {
        double[] y = new double[]{0.0, 1.0, -2.0};
        DummyStepInterpolator interpolator = new DummyStepInterpolator(y, new double[y.length], true);
        interpolator.storeTime(0.0);
        interpolator.shift();
        interpolator.storeTime(1.0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject((Object)interpolator);
        Assert.assertTrue((bos.size() > 300 ? 1 : 0) != 0);
        Assert.assertTrue((bos.size() < 500 ? 1 : 0) != 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        DummyStepInterpolator dsi = (DummyStepInterpolator)((Object)ois.readObject());
        dsi.setInterpolatedTime(0.5);
        double[] result = dsi.getInterpolatedState();
        for (int i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testImpossibleSerialization() throws IOException {
        double[] y = new double[]{0.0, 1.0, -2.0};
        BadStepInterpolator interpolator = new BadStepInterpolator(y, true);
        interpolator.storeTime(0.0);
        interpolator.shift();
        interpolator.storeTime(1.0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject((Object)interpolator);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (LocalException localException) {
            // empty catch block
        }
    }

    private static class LocalException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private LocalException() {
        }
    }

    private static class BadStepInterpolator
    extends DummyStepInterpolator {
        public BadStepInterpolator(double[] y, boolean forward) {
            super(y, new double[y.length], forward);
        }

        protected void doFinalize() {
            throw new LocalException();
        }
    }
}

