/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.stat.clustering.Cluster;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.stat.clustering.EuclideanIntegerPoint;
import org.apache.commons.math3.stat.clustering.KMeansPlusPlusClusterer;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class KMeansPlusPlusClustererTest {
    @Test
    public void dimension2() {
        KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(new Random(1746432956321L));
        EuclideanIntegerPoint[] points = new EuclideanIntegerPoint[]{new EuclideanIntegerPoint(new int[]{-15, 3}), new EuclideanIntegerPoint(new int[]{-15, 4}), new EuclideanIntegerPoint(new int[]{-15, 5}), new EuclideanIntegerPoint(new int[]{-14, 3}), new EuclideanIntegerPoint(new int[]{-14, 5}), new EuclideanIntegerPoint(new int[]{-13, 3}), new EuclideanIntegerPoint(new int[]{-13, 4}), new EuclideanIntegerPoint(new int[]{-13, 5}), new EuclideanIntegerPoint(new int[]{-1, 0}), new EuclideanIntegerPoint(new int[]{-1, -1}), new EuclideanIntegerPoint(new int[]{0, -1}), new EuclideanIntegerPoint(new int[]{1, -1}), new EuclideanIntegerPoint(new int[]{1, -2}), new EuclideanIntegerPoint(new int[]{13, 3}), new EuclideanIntegerPoint(new int[]{13, 4}), new EuclideanIntegerPoint(new int[]{14, 4}), new EuclideanIntegerPoint(new int[]{14, 7}), new EuclideanIntegerPoint(new int[]{16, 5}), new EuclideanIntegerPoint(new int[]{16, 6}), new EuclideanIntegerPoint(new int[]{17, 4}), new EuclideanIntegerPoint(new int[]{17, 7})};
        List clusters = transformer.cluster(Arrays.asList(points), 3, 5, 10);
        Assert.assertEquals((long)3L, (long)clusters.size());
        boolean cluster1Found = false;
        boolean cluster2Found = false;
        boolean cluster3Found = false;
        for (Cluster cluster : clusters) {
            int[] center = ((EuclideanIntegerPoint)cluster.getCenter()).getPoint();
            if (center[0] < 0) {
                cluster1Found = true;
                Assert.assertEquals((long)8L, (long)cluster.getPoints().size());
                Assert.assertEquals((long)-14L, (long)center[0]);
                Assert.assertEquals((long)4L, (long)center[1]);
                continue;
            }
            if (center[1] < 0) {
                cluster2Found = true;
                Assert.assertEquals((long)5L, (long)cluster.getPoints().size());
                Assert.assertEquals((long)0L, (long)center[0]);
                Assert.assertEquals((long)-1L, (long)center[1]);
                continue;
            }
            cluster3Found = true;
            Assert.assertEquals((long)8L, (long)cluster.getPoints().size());
            Assert.assertEquals((long)15L, (long)center[0]);
            Assert.assertEquals((long)5L, (long)center[1]);
        }
        Assert.assertTrue((boolean)cluster1Found);
        Assert.assertTrue((boolean)cluster2Found);
        Assert.assertTrue((boolean)cluster3Found);
    }

    @Test
    public void testPerformClusterAnalysisDegenerate() {
        KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(new Random(1746432956321L));
        EuclideanIntegerPoint[] points = new EuclideanIntegerPoint[]{new EuclideanIntegerPoint(new int[]{1959, 325100}), new EuclideanIntegerPoint(new int[]{1960, 373200})};
        List clusters = transformer.cluster(Arrays.asList(points), 1, 1);
        Assert.assertEquals((long)1L, (long)clusters.size());
        Assert.assertEquals((long)2L, (long)((Cluster)clusters.get(0)).getPoints().size());
        EuclideanIntegerPoint pt1 = new EuclideanIntegerPoint(new int[]{1959, 325100});
        EuclideanIntegerPoint pt2 = new EuclideanIntegerPoint(new int[]{1960, 373200});
        Assert.assertTrue((boolean)((Cluster)clusters.get(0)).getPoints().contains(pt1));
        Assert.assertTrue((boolean)((Cluster)clusters.get(0)).getPoints().contains(pt2));
    }

    @Test
    public void testCertainSpace() {
        KMeansPlusPlusClusterer.EmptyClusterStrategy[] strategies;
        for (KMeansPlusPlusClusterer.EmptyClusterStrategy strategy : strategies = new KMeansPlusPlusClusterer.EmptyClusterStrategy[]{KMeansPlusPlusClusterer.EmptyClusterStrategy.LARGEST_VARIANCE, KMeansPlusPlusClusterer.EmptyClusterStrategy.LARGEST_POINTS_NUMBER, KMeansPlusPlusClusterer.EmptyClusterStrategy.FARTHEST_POINT}) {
            KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(new Random(1746432956321L), strategy);
            int numberOfVariables = 27;
            int position1 = 1;
            int position2 = position1 + numberOfVariables;
            int position3 = position2 + numberOfVariables;
            int position4 = position3 + numberOfVariables;
            int multiplier = 1000000;
            EuclideanIntegerPoint[] breakingPoints = new EuclideanIntegerPoint[numberOfVariables];
            for (int i = 0; i < numberOfVariables; ++i) {
                EuclideanIntegerPoint euclideanIntegerPoint;
                int[] points = new int[]{position1, position2, position3, position4};
                int j = 0;
                while (j < points.length) {
                    int n = j++;
                    points[n] = points[n] * multiplier;
                }
                breakingPoints[i] = euclideanIntegerPoint = new EuclideanIntegerPoint(points);
                position1 += numberOfVariables;
                position2 += numberOfVariables;
                position3 += numberOfVariables;
                position4 += numberOfVariables;
            }
            for (int n = 2; n < 27; ++n) {
                List clusters = transformer.cluster(Arrays.asList(breakingPoints), n, 100);
                Assert.assertEquals((long)n, (long)clusters.size());
                int sum = 0;
                for (Cluster cluster : clusters) {
                    sum += cluster.getPoints().size();
                }
                Assert.assertEquals((long)numberOfVariables, (long)sum);
            }
        }
    }

    @Test
    public void testSmallDistances() {
        int[] repeatedArray = new int[]{0};
        int[] uniqueArray = new int[]{1};
        CloseIntegerPoint repeatedPoint = new CloseIntegerPoint(new EuclideanIntegerPoint(repeatedArray));
        CloseIntegerPoint uniquePoint = new CloseIntegerPoint(new EuclideanIntegerPoint(uniqueArray));
        ArrayList<CloseIntegerPoint> points = new ArrayList<CloseIntegerPoint>();
        int NUM_REPEATED_POINTS = 10000;
        for (int i = 0; i < 10000; ++i) {
            points.add(repeatedPoint);
        }
        points.add(uniquePoint);
        long RANDOM_SEED = 0L;
        int NUM_CLUSTERS = 2;
        boolean NUM_ITERATIONS = false;
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(new Random(0L));
        List clusters = clusterer.cluster(points, 2, 0);
        boolean uniquePointIsCenter = false;
        for (Cluster cluster : clusters) {
            if (!((CloseIntegerPoint)cluster.getCenter()).equals(uniquePoint)) continue;
            uniquePointIsCenter = true;
        }
        Assert.assertTrue((boolean)uniquePointIsCenter);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testPerformClusterAnalysisToManyClusters() {
        KMeansPlusPlusClusterer transformer = new KMeansPlusPlusClusterer(new Random(1746432956321L));
        EuclideanIntegerPoint[] points = new EuclideanIntegerPoint[]{new EuclideanIntegerPoint(new int[]{1959, 325100}), new EuclideanIntegerPoint(new int[]{1960, 373200})};
        transformer.cluster(Arrays.asList(points), 3, 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloseIntegerPoint
    implements Clusterable<CloseIntegerPoint> {
        private EuclideanIntegerPoint euclideanPoint;

        public CloseIntegerPoint(EuclideanIntegerPoint point) {
            this.euclideanPoint = point;
        }

        public double distanceFrom(CloseIntegerPoint p) {
            return this.euclideanPoint.distanceFrom(p.euclideanPoint) * 0.001;
        }

        public CloseIntegerPoint centroidOf(Collection<CloseIntegerPoint> p) {
            ArrayList<EuclideanIntegerPoint> euclideanPoints = new ArrayList<EuclideanIntegerPoint>();
            for (CloseIntegerPoint point : p) {
                euclideanPoints.add(point.euclideanPoint);
            }
            return new CloseIntegerPoint(this.euclideanPoint.centroidOf(euclideanPoints));
        }

        public boolean equals(Object o) {
            if (!(o instanceof CloseIntegerPoint)) {
                return false;
            }
            CloseIntegerPoint p = (CloseIntegerPoint)o;
            return this.euclideanPoint.equals((Object)p.euclideanPoint);
        }

        public int hashCode() {
            return this.euclideanPoint.hashCode();
        }
    }
}

