/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.solvers;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.legacy.exception.NoBracketingException;
import org.apache.commons.math4.legacy.exception.TooManyEvaluationsException;

public class RiddersSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public RiddersSolver() {
        this(1.0E-6);
    }

    public RiddersSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public RiddersSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException, NoBracketingException {
        double min = this.getMin();
        double max = this.getMax();
        double x1 = min;
        double y1 = this.computeObjectiveValue(x1);
        double x2 = max;
        double y2 = this.computeObjectiveValue(x2);
        if (y1 == 0.0) {
            return min;
        }
        if (y2 == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max);
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        double relativeAccuracy = this.getRelativeAccuracy();
        double oldx = Double.POSITIVE_INFINITY;
        double x3;
        double y3;
        while (!(JdkMath.abs((double)(y3 = this.computeObjectiveValue(x3 = 0.5 * (x1 + x2)))) <= functionValueAccuracy)) {
            double delta = 1.0 - y1 * y2 / (y3 * y3);
            double correction = JdkMath.signum((double)y2) * JdkMath.signum((double)y3) * (x3 - x1) / JdkMath.sqrt((double)delta);
            double x = x3 - correction;
            double y = this.computeObjectiveValue(x);
            double tolerance = JdkMath.max((double)(relativeAccuracy * JdkMath.abs((double)x)), (double)absoluteAccuracy);
            if (JdkMath.abs((double)(x - oldx)) <= tolerance) {
                return x;
            }
            if (JdkMath.abs((double)y) <= functionValueAccuracy) {
                return x;
            }
            if (correction > 0.0) {
                if (JdkMath.signum((double)y1) + JdkMath.signum((double)y) == 0.0) {
                    x2 = x;
                    y2 = y;
                } else {
                    x1 = x;
                    x2 = x3;
                    y1 = y;
                    y2 = y3;
                }
            } else if (JdkMath.signum((double)y2) + JdkMath.signum((double)y) == 0.0) {
                x1 = x;
                y1 = y;
            } else {
                x1 = x3;
                x2 = x;
                y1 = y3;
                y2 = y;
            }
            oldx = x;
        }
        return x3;
    }
}

