/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.clustering;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math4.legacy.ml.clustering.CentroidCluster;
import org.apache.commons.math4.legacy.ml.clustering.ClusterEvaluator;
import org.apache.commons.math4.legacy.ml.clustering.ClusterRanking;
import org.apache.commons.math4.legacy.ml.clustering.Clusterable;
import org.apache.commons.math4.legacy.ml.clustering.Clusterer;
import org.apache.commons.math4.legacy.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math4.legacy.ml.clustering.evaluation.SumOfClusterVariances;

public class MultiKMeansPlusPlusClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final KMeansPlusPlusClusterer<T> clusterer;
    private final int numTrials;
    private final ClusterRanking evaluator;

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> clusterer, int numTrials) {
        this(clusterer, numTrials, ClusterEvaluator.ranking(new SumOfClusterVariances(clusterer.getDistanceMeasure())));
    }

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> clusterer, int numTrials, ClusterRanking evaluator) {
        super(clusterer.getDistanceMeasure());
        this.clusterer = clusterer;
        this.numTrials = numTrials;
        this.evaluator = evaluator;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> points) {
        List<CentroidCluster<T>> best = null;
        double bestRank = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numTrials; ++i) {
            List<CentroidCluster<T>> clusters = this.clusterer.cluster(points);
            double rank = this.evaluator.compute(clusters);
            if (!(rank > bestRank)) continue;
            best = clusters;
            bestRank = rank;
        }
        return best;
    }
}

