/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.transform;

import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.transform.FastFourierTransform;
import org.apache.commons.math4.transform.RealTransform;
import org.apache.commons.math4.transform.TransformException;
import org.apache.commons.math4.transform.TransformUtils;
import org.apache.commons.numbers.complex.Complex;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class FastCosineTransform
implements RealTransform {
    private final UnaryOperator<double[]> op;

    public FastCosineTransform(Norm normalization, boolean inverse) {
        this.op = this.create(normalization, inverse);
    }

    public FastCosineTransform(Norm normalization) {
        this(normalization, false);
    }

    @Override
    public double[] apply(double[] f) {
        return (double[])this.op.apply(f);
    }

    @Override
    public double[] apply(DoubleUnaryOperator f, double min, double max, int n) {
        return this.apply(TransformUtils.sample(f, min, max, n));
    }

    private double[] fct(double[] f) {
        int n = f.length - 1;
        if (!ArithmeticUtils.isPowerOfTwo((long)n)) {
            throw new TransformException("{0} is not equal to 1 + pow(2, n), for some n", f.length);
        }
        double[] transformed = new double[f.length];
        if (n == 1) {
            transformed[0] = 0.5 * (f[0] + f[1]);
            transformed[1] = 0.5 * (f[0] - f[1]);
            return transformed;
        }
        double[] x = new double[n];
        x[0] = 0.5 * (f[0] + f[n]);
        int nShifted = n >> 1;
        x[nShifted] = f[nShifted];
        double t1 = 0.5 * (f[0] - f[n]);
        double piOverN = Math.PI / (double)n;
        for (int i = 1; i < nShifted; ++i) {
            int nMi = n - i;
            double fi = f[i];
            double fnMi = f[nMi];
            double a = 0.5 * (fi + fnMi);
            double arg = (double)i * piOverN;
            double b = Math.sin(arg) * (fi - fnMi);
            double c = Math.cos(arg) * (fi - fnMi);
            x[i] = a - b;
            x[nMi] = a + b;
            t1 += c;
        }
        FastFourierTransform transformer = new FastFourierTransform(FastFourierTransform.Norm.STD, false);
        Complex[] y = transformer.apply(x);
        transformed[0] = y[0].getReal();
        transformed[1] = t1;
        for (int i = 1; i < nShifted; ++i) {
            int i2 = 2 * i;
            transformed[i2] = y[i].getReal();
            transformed[i2 + 1] = transformed[i2 - 1] - y[i].getImaginary();
        }
        transformed[n] = y[nShifted].getReal();
        return transformed;
    }

    private UnaryOperator<double[]> create(Norm normalization, boolean inverse) {
        if (inverse) {
            return normalization == Norm.ORTHO ? f -> TransformUtils.scaleInPlace(this.fct((double[])f), Math.sqrt(2.0 / (double)(((double[])f).length - 1))) : f -> TransformUtils.scaleInPlace(this.fct((double[])f), 2.0 / (double)(((double[])f).length - 1));
        }
        return normalization == Norm.ORTHO ? f -> TransformUtils.scaleInPlace(this.fct((double[])f), Math.sqrt(2.0 / (double)(((double[])f).length - 1))) : f -> this.fct((double[])f);
    }

    public static enum Norm {
        STD,
        ORTHO;

    }
}

