/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.sofm;

import org.apache.commons.math4.neuralnet.sofm.NeighbourhoodSizeFunction;
import org.apache.commons.math4.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math4.neuralnet.sofm.util.QuasiSigmoidDecayFunction;

public final class NeighbourhoodSizeFunctionFactory {
    private NeighbourhoodSizeFunctionFactory() {
    }

    public static NeighbourhoodSizeFunction exponentialDecay(final double initValue, final double valueAtNumCall, final long numCall) {
        return new NeighbourhoodSizeFunction(){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(initValue, valueAtNumCall, numCall);
            }

            @Override
            public int value(long n) {
                return (int)Math.rint(this.decay.applyAsDouble(n));
            }
        };
    }

    public static NeighbourhoodSizeFunction quasiSigmoidDecay(final double initValue, final double slope, final long numCall) {
        return new NeighbourhoodSizeFunction(){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(initValue, slope, numCall);
            }

            @Override
            public int value(long n) {
                return (int)Math.rint(this.decay.applyAsDouble(n));
            }
        };
    }
}

