/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.sofm.util;

import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class QuasiSigmoidDecayFunction
implements LongToDoubleFunction {
    private final DoubleUnaryOperator sigmoid;
    private final double scale;

    public QuasiSigmoidDecayFunction(double initValue, double slope, long numCall) {
        if (initValue <= 0.0) {
            throw new NeuralNetException("Number {0} is not strictly positive", initValue);
        }
        if (slope >= 0.0) {
            throw new NeuralNetException("Number {0} is larger than {1}", slope, 0);
        }
        if (numCall <= 1L) {
            throw new NeuralNetException("Number {0} is smaller than {1}", numCall, 1);
        }
        double k = initValue;
        double m = numCall;
        double b = 4.0 * slope / initValue;
        this.sigmoid = x -> k / (1.0 + Math.exp(b * (m - x)));
        double y0 = this.sigmoid.applyAsDouble(0.0);
        this.scale = k / y0;
    }

    @Override
    public double applyAsDouble(long numCall) {
        return this.scale * this.sigmoid.applyAsDouble(numCall);
    }
}

