/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class IOSystem {
    private static final Logger LOG = Logger.getLogger(IOSystem.class);

    public String slurp(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(file, (OutputStream)out);
        return new String(out.toByteArray());
    }

    public String slurp(URL url) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(url.openStream(), (OutputStream)out);
        return new String(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeString(File file, String string) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(out);
            try {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            finally {
                this.close(bufferedWriter);
            }
        }
        finally {
            this.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File from, OutputStream to) throws IOException {
        InputStream read = this.read(from);
        try {
            this.copy(read, to);
        }
        finally {
            this.close(read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream from, File to) throws IOException {
        OutputStream write = this.write(to);
        try {
            this.copy(from, write);
        }
        finally {
            this.close(write);
        }
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    public void copy(byte[] from, File to) throws IOException {
        this.copy((InputStream)new ByteArrayInputStream(from), to);
    }

    public ZipInputStream unzip(File file) throws IOException {
        InputStream read = this.read(file);
        return new ZipInputStream(read);
    }

    public void close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            if (closeable instanceof Flushable) {
                ((Flushable)((Object)closeable)).flush();
            }
        }
        catch (IOException e) {
            LOG.trace((Object)("Error when trying to flush before closing " + closeable), (Throwable)e);
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.trace((Object)("Error when trying to close " + closeable), (Throwable)e);
        }
    }

    public OutputStream write(File destination) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(destination);
        return new BufferedOutputStream(out, 32768);
    }

    public InputStream read(File source) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(source);
        return new BufferedInputStream(in, 32768);
    }

    public byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(in, (OutputStream)out);
        out.close();
        return out.toByteArray();
    }
}

