/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Random;
import org.apache.datasketches.quantilescommon.BinarySearch;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InequalitySearchTest {
    static Random rand = new Random(1L);
    private static final String LS = System.getProperty("line.separator");
    private static final boolean enablePrinting = false;

    private static int randDelta() {
        return rand.nextDouble() < 0.4 ? 0 : 1;
    }

    private static float[] buildRandFloatArr(int len) {
        float[] arr = new float[len];
        float v = 1.0f;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += (float)InequalitySearchTest.randDelta();
        }
        return arr;
    }

    private static double[] buildRandDoubleArr(int len) {
        double[] arr = new double[len];
        double v = 1.0;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += (double)InequalitySearchTest.randDelta();
        }
        return arr;
    }

    private static long[] buildRandLongArr(int len) {
        long[] arr = new long[len];
        long v = 1L;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += 2L * (long)InequalitySearchTest.randDelta();
        }
        return arr;
    }

    @Test
    public void checkBinSearchDblLimits() {
        for (int len = 10; len <= 13; ++len) {
            double[] tarr = InequalitySearchTest.buildRandDoubleArr(len);
            int low = 2;
            int high = len - 2;
            InequalitySearchTest.println(InequalitySearchTest.listDblArray(tarr, 2, high));
            InequalitySearchTest.checkBinarySearchDoubleLimits(tarr, 2, high);
        }
    }

    private static String listDblArray(double[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("double[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%.0f) ", arr[i]));
                continue;
            }
            sb.append(String.format("%.0f ", arr[i]));
        }
        return sb.toString();
    }

    private static void checkBinarySearchDoubleLimits(double[] arr, int low, int high) {
        double lowV = arr[low];
        double highV = arr[high];
        double v = lowV - 1.0;
        int res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((double)arr[res], (double)v);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void checkBinSearchFltLimits() {
        for (int len = 10; len <= 13; ++len) {
            float[] tarr = InequalitySearchTest.buildRandFloatArr(len);
            int low = 2;
            int high = len - 2;
            InequalitySearchTest.println(InequalitySearchTest.listFltArray(tarr, 2, high));
            InequalitySearchTest.checkBinarySearchFloatLimits(tarr, 2, high);
        }
    }

    private static String listFltArray(float[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("float[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%.0f) ", Float.valueOf(arr[i])));
                continue;
            }
            sb.append(String.format("%.0f ", Float.valueOf(arr[i])));
        }
        return sb.toString();
    }

    private static void checkBinarySearchFloatLimits(float[] arr, int low, int high) {
        float lowV = arr[low];
        float highV = arr[high];
        float v = lowV - 1.0f;
        int res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((float)arr[res], (float)v);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void checkBinSearchLongLimits() {
        for (int len = 10; len <= 13; ++len) {
            long[] tarr = InequalitySearchTest.buildRandLongArr(len);
            int low = 2;
            int high = len - 2;
            InequalitySearchTest.println(InequalitySearchTest.listLongArray(tarr, 2, high));
            InequalitySearchTest.checkBinarySearchLongLimits(tarr, 2, high);
        }
    }

    private static String listLongArray(long[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("long[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%d) ", arr[i]));
                continue;
            }
            sb.append(String.format("%d ", arr[i]));
        }
        return sb.toString();
    }

    private static void checkBinarySearchLongLimits(long[] arr, int low, int high) {
        long lowV = arr[low];
        long highV = arr[high];
        long v = lowV - 1L;
        int res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        InequalitySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        InequalitySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((long)arr[res], (long)v);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        InequalitySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        InequalitySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        InequalitySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void exerciseDoublesSearch() {
        InequalitySearchTest.println("--------{1f}--------");
        double[] arr = new double[]{1.0};
        InequalitySearchTest.exerciseDoubles(arr);
        InequalitySearchTest.println("------{1f, 1f}------");
        arr = new double[]{1.0, 1.0};
        InequalitySearchTest.exerciseDoubles(arr);
        InequalitySearchTest.println("---------{1,1,1,2,2,2,3,4,4,4}--------");
        arr = new double[]{1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 3.0, 4.0, 4.0, 4.0};
        InequalitySearchTest.exerciseDoubles(arr);
    }

    private static void exerciseDoubles(double[] arr) {
        InequalitySearchTest.checkFindDouble(arr, InequalitySearch.LT);
        InequalitySearchTest.checkFindDouble(arr, InequalitySearch.LE);
        InequalitySearchTest.checkFindDouble(arr, InequalitySearch.EQ);
        InequalitySearchTest.checkFindDouble(arr, InequalitySearch.GE);
        InequalitySearchTest.checkFindDouble(arr, InequalitySearch.GT);
    }

    private static void checkFindDouble(double[] arr, InequalitySearch crit) {
        InequalitySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (double v = 0.5; v <= arr[len - 1] + 0.5; v += 0.5) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((double[])arr, (int)0, (int)high, (double)v, (InequalitySearch)crit);
            InequalitySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        InequalitySearchTest.println("");
    }

    @Test
    public void exerciseFloatsSearch() {
        InequalitySearchTest.println("--------{1f}--------");
        float[] arr = new float[]{1.0f};
        InequalitySearchTest.exerciseFloats(arr);
        InequalitySearchTest.println("------{1f, 1f}------");
        arr = new float[]{1.0f, 1.0f};
        InequalitySearchTest.exerciseFloats(arr);
        InequalitySearchTest.println("---------{1,1,1,2,2,2,3,4,4,4}--------");
        arr = new float[]{1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 3.0f, 4.0f, 4.0f, 4.0f};
        InequalitySearchTest.exerciseFloats(arr);
    }

    private static void exerciseFloats(float[] arr) {
        InequalitySearchTest.checkFindFloat(arr, InequalitySearch.LT);
        InequalitySearchTest.checkFindFloat(arr, InequalitySearch.LE);
        InequalitySearchTest.checkFindFloat(arr, InequalitySearch.EQ);
        InequalitySearchTest.checkFindFloat(arr, InequalitySearch.GE);
        InequalitySearchTest.checkFindFloat(arr, InequalitySearch.GT);
    }

    private static void checkFindFloat(float[] arr, InequalitySearch crit) {
        InequalitySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (float v = 0.5f; v <= arr[len - 1] + 0.5f; v += 0.5f) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((float[])arr, (int)0, (int)high, (float)v, (InequalitySearch)crit);
            InequalitySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        InequalitySearchTest.println("");
    }

    @Test
    public void exerciseLongsSearch() {
        InequalitySearchTest.println("--------{1}--------");
        long[] arr = new long[]{1L};
        InequalitySearchTest.exerciseLongs(arr);
        InequalitySearchTest.println("------{1, 1}------");
        arr = new long[]{1L, 1L};
        InequalitySearchTest.exerciseLongs(arr);
        InequalitySearchTest.println("--------{1,1,1,2,2,2,3,4,4,4}--------");
        arr = new long[]{1L, 1L, 1L, 2L, 2L, 2L, 3L, 4L, 4L, 4L};
        InequalitySearchTest.exerciseLongs(arr);
    }

    private static void exerciseLongs(long[] arr) {
        InequalitySearchTest.checkFindLong(arr, InequalitySearch.LT);
        InequalitySearchTest.checkFindLong(arr, InequalitySearch.LE);
        InequalitySearchTest.checkFindLong(arr, InequalitySearch.EQ);
        InequalitySearchTest.checkFindLong(arr, InequalitySearch.GE);
        InequalitySearchTest.checkFindLong(arr, InequalitySearch.GT);
    }

    private static void checkFindLong(long[] arr, InequalitySearch crit) {
        InequalitySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (long v = 0L; v <= arr[len - 1] + 1L; ++v) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((long[])arr, (int)0, (int)high, (long)v, (InequalitySearch)crit);
            InequalitySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        InequalitySearchTest.println("");
    }

    @Test
    public void checkSimpleFindFloat() {
        int idx;
        int len = 10;
        float[] arr = new float[10];
        for (int i = 0; i < 10; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 10; ++i) {
            idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)-1.0f);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)10.0f);
        Assert.assertEquals((int)idx, (int)-1);
    }

    @Test
    public void checkSimpleFindDouble() {
        int idx;
        int len = 11;
        double[] arr = new double[11];
        for (int i = 0; i < 11; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 11; ++i) {
            idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)-1.0);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)11.0);
        Assert.assertEquals((int)idx, (int)-1);
    }

    @Test
    public void checkSimpleFindLong() {
        int idx;
        int len = 11;
        long[] arr = new long[11];
        for (int i = 0; i < 11; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 11; ++i) {
            idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)-1L);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)11L);
        Assert.assertEquals((int)idx, (int)-1);
    }

    @Test
    private static void checkBuildRandFloatArr() {
        int len = 10;
        for (int i = 0; i < 10; ++i) {
            float[] tarr = InequalitySearchTest.buildRandFloatArr(10);
            for (int j = 0; j < 10; ++j) {
                InequalitySearchTest.printf("%4.1f,", Float.valueOf(tarr[j]));
            }
            InequalitySearchTest.println("");
        }
    }

    static final void printf(String format, Object ... args) {
    }

    static final void println(Object o) {
    }
}

