/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hllmap;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hllmap.CouponHashMap;
import org.apache.datasketches.hllmap.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CouponHashMapTest {
    @Test
    public void getEstimateNoEntry() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)16);
        byte[] key = new byte[]{0, 0, 0, 0};
        Assert.assertEquals((double)map.getEstimate(key), (double)0.0);
        Assert.assertEquals((double)map.getUpperBound(key), (double)0.0);
        Assert.assertEquals((double)map.getLowerBound(key), (double)0.0);
    }

    @Test
    public void oneKeyOneEntry() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)16);
        byte[] key = new byte[]{0, 0, 0, 0};
        double estimate = map.update(key, (short)1);
        Assert.assertEquals((double)estimate, (double)1.0);
        Assert.assertEquals((double)map.getEstimate(key), (double)1.0);
        Assert.assertTrue((map.getUpperBound(key) > 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((map.getLowerBound(key) < 1.0 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void keyNotFound() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)16);
        byte[] key = new byte[]{0, 0, 0, 0};
        map.update(key, (short)1);
        map.updateEstimate(map.findKey(new byte[]{1, 0, 0, 0}), 2.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrongCouponsPerKey() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)8);
        CouponHashMapTest.println(map.toString());
    }

    @Test
    public void delete() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)16);
        double estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), (short)1);
        Assert.assertEquals((double)estimate, (double)1.0);
        int index1 = map.findKey("1234".getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((index1 >= 0 ? 1 : 0) != 0);
        map.deleteKey(index1);
        int index2 = map.findKey("1234".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((int)(~index2), (int)index1);
        Assert.assertEquals((double)map.getEstimate("1234".getBytes(StandardCharsets.UTF_8)), (double)0.0);
    }

    @Test
    public void growAndShrink() {
        CouponHashMap map = CouponHashMap.getInstance((int)4, (int)16);
        long sizeBytes1 = map.getMemoryUsageBytes();
        for (int i = 0; i < 1000; ++i) {
            byte[] key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            map.update(key, (short)Map.coupon16((byte[])new byte[]{1}));
        }
        long sizeBytes2 = map.getMemoryUsageBytes();
        Assert.assertTrue((sizeBytes2 > sizeBytes1 ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            byte[] key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            int index = map.findKey(key);
            Assert.assertTrue((index >= 0 ? 1 : 0) != 0);
            map.deleteKey(index);
        }
        long sizeBytes3 = map.getMemoryUsageBytes();
        Assert.assertTrue((sizeBytes3 < sizeBytes2 ? 1 : 0) != 0);
        CouponHashMapTest.println(map.toString());
    }

    @Test
    public void printlnTest() {
        CouponHashMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

