/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesAnotB;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCombiner;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesIntersection;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CornerCaseArrayOfDoublesSetOperationsTest {
    private static final float MIDP_FLT = 0.5f;
    private static final float LOWP_FLT = 0.125f;
    private static final long GT_MIDP_KEY = 3L;
    private static final long GT_LOWP_KEY = 6L;
    private static final long LT_LOWP_KEY = 4L;
    private static final long MAX_LONG = Long.MAX_VALUE;
    private static final long HASH_GT_MIDP = CornerCaseArrayOfDoublesSetOperationsTest.getLongHash(3L);
    private static final long MIDP_THETALONG = 0x4000000000000000L;
    private static final long HASH_GT_LOWP = CornerCaseArrayOfDoublesSetOperationsTest.getLongHash(6L);
    private static final long LOWP_THETALONG = 0x1000000000000000L;
    private static final long HASH_LT_LOWP = CornerCaseArrayOfDoublesSetOperationsTest.getLongHash(4L);
    private static final String LS = System.getProperty("line.separator");
    private static MinCombiner minCombiner = new MinCombiner();

    @Test
    public void emptyEmpty() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = true;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 0, true);
    }

    @Test
    public void emptyExact() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void emptyDegenerate() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.125, 0, false);
    }

    @Test
    public void emptyEstimation() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 0, true, 0.125, 1, false);
    }

    @Test
    public void exactEmpty() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 1.0, 1, false, 1.0, 1, false);
    }

    @Test
    public void exactExact() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 1, false, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void exactDegenerate() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 0, false, 0.125, 1, false, 0.125, 1, false);
    }

    @Test
    public void exactEstimation() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 1, false, 0.125, 0, false, 0.125, 1, false);
    }

    @Test
    public void estimationEmpty() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.125, 1, false, 0.125, 1, false);
    }

    @Test
    public void estimationExact() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 1, false, 0.125, 0, false, 0.125, 1, false);
    }

    @Test
    public void estimationDegenerate() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 0, false, 0.125, 1, false, 0.125, 1, false);
    }

    @Test
    public void estimationEstimation() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.5f, 4L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 1, false, 0.125, 0, false, 0.125, 1, false);
    }

    @Test
    public void degenerateEmpty() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 1.0, 0, true, 0.125, 0, false, 0.125, 0, false);
    }

    @Test
    public void degenerateExact() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 0, false, 0.125, 0, false, 0.125, 1, false);
    }

    @Test
    public void degenerateDegenerate() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.125f, 6L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 0, false, 0.125, 0, false, 0.125, 0, false);
    }

    @Test
    public void degenerateEstimation() {
        ArrayOfDoublesUpdatableSketch thetaA = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.DEGENERATE, 0.5f, 3L);
        ArrayOfDoublesUpdatableSketch thetaB = CornerCaseArrayOfDoublesSetOperationsTest.getSketch(SkType.ESTIMATION, 0.125f, 4L);
        double expectedIntersectTheta = 0.125;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.125;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.125;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        CornerCaseArrayOfDoublesSetOperationsTest.checks(thetaA, thetaB, 0.125, 0, false, 0.125, 0, false, 0.125, 1, false);
    }

    private static void checks(ArrayOfDoublesUpdatableSketch tupleA, ArrayOfDoublesUpdatableSketch tupleB, double expectedIntersectTheta, int expectedIntersectCount, boolean expectedIntersectEmpty, double expectedAnotbTheta, int expectedAnotbCount, boolean expectedAnotbEmpty, double expectedUnionTheta, int expectedUnionCount, boolean expectedUnionEmpty) {
        ArrayOfDoublesIntersection inter = new ArrayOfDoublesSetOperationBuilder().buildIntersection();
        ArrayOfDoublesAnotB anotb = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        inter.intersect((ArrayOfDoublesSketch)tupleA, (ArrayOfDoublesCombiner)minCombiner);
        inter.intersect((ArrayOfDoublesSketch)tupleB, (ArrayOfDoublesCombiner)minCombiner);
        ArrayOfDoublesCompactSketch csk = inter.getResult();
        inter.reset();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("Intersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        inter.intersect((ArrayOfDoublesSketch)tupleA.compact(), (ArrayOfDoublesCombiner)minCombiner);
        inter.intersect((ArrayOfDoublesSketch)tupleB.compact(), (ArrayOfDoublesCombiner)minCombiner);
        csk = inter.getResult();
        inter.reset();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("Intersect Stateless Theta, Theta", csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        anotb.update((ArrayOfDoublesSketch)tupleA, (ArrayOfDoublesSketch)tupleB);
        csk = anotb.getResult();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("TupleAnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.update((ArrayOfDoublesSketch)tupleA, (ArrayOfDoublesSketch)tupleB);
        csk = anotb.getResult();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("TupleAnotB Stateless Theta, Theta", csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        union.union((ArrayOfDoublesSketch)tupleA);
        union.union((ArrayOfDoublesSketch)tupleB);
        csk = union.getResult();
        union.reset();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("TupleUnion Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((ArrayOfDoublesSketch)tupleA.compact());
        union.union((ArrayOfDoublesSketch)tupleB.compact());
        csk = union.getResult();
        union.reset();
        CornerCaseArrayOfDoublesSetOperationsTest.checkResult("TupleUnion Stateless Theta, Theta", csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
    }

    private static void checkResult(String comment, ArrayOfDoublesCompactSketch csk, double expectedTheta, int expectedEntries, boolean expectedEmpty) {
        boolean emptyOk;
        double actualTheta = csk.getTheta();
        int actualEntries = csk.getRetainedEntries();
        boolean actualEmpty = csk.isEmpty();
        boolean thetaOk = actualTheta == expectedTheta;
        boolean entriesOk = actualEntries == expectedEntries;
        boolean bl = emptyOk = actualEmpty == expectedEmpty;
        if (!(thetaOk && entriesOk && emptyOk)) {
            StringBuilder sb = new StringBuilder();
            sb.append(comment + ": ");
            if (!thetaOk) {
                sb.append("Theta: expected " + expectedTheta + ", got " + actualTheta + "; ");
            }
            if (!entriesOk) {
                sb.append("Entries: expected " + expectedEntries + ", got " + actualEntries + "; ");
            }
            if (!emptyOk) {
                sb.append("Empty: expected " + expectedEmpty + ", got " + actualEmpty + ".");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static ArrayOfDoublesUpdatableSketch getSketch(SkType skType, float p, long updateKey) {
        ArrayOfDoublesUpdatableSketch sk;
        ArrayOfDoublesUpdatableSketchBuilder bldr = new ArrayOfDoublesUpdatableSketchBuilder();
        bldr.setNominalEntries(16);
        double[] summaryVal = new double[]{1.0};
        switch (skType.ordinal()) {
            case 0: {
                sk = bldr.build();
                break;
            }
            case 1: {
                sk = bldr.build();
                sk.update(updateKey, summaryVal);
                break;
            }
            case 2: {
                CornerCaseArrayOfDoublesSetOperationsTest.checkValidUpdate(p, updateKey);
                bldr.setSamplingProbability(p);
                sk = bldr.build();
                sk.update(updateKey, summaryVal);
                break;
            }
            case 3: {
                CornerCaseArrayOfDoublesSetOperationsTest.checkInvalidUpdate(p, updateKey);
                bldr.setSamplingProbability(p);
                sk = bldr.build();
                sk.update(updateKey, summaryVal);
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static void checkValidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseArrayOfDoublesSetOperationsTest.getLongHash(updateKey) < (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    private static void checkInvalidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseArrayOfDoublesSetOperationsTest.getLongHash(updateKey) > (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    public void printTable() {
        CornerCaseArrayOfDoublesSetOperationsTest.println("              Top8bits  Hex               Decimal");
        CornerCaseArrayOfDoublesSetOperationsTest.printf("MAX:           %8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(Long.MAX_VALUE), Long.MAX_VALUE, Long.MAX_VALUE);
        CornerCaseArrayOfDoublesSetOperationsTest.printf("GT_MIDP:       %8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(HASH_GT_MIDP), HASH_GT_MIDP, HASH_GT_MIDP);
        CornerCaseArrayOfDoublesSetOperationsTest.printf("MIDP_THETALONG:%8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(0x4000000000000000L), 0x4000000000000000L, 0x4000000000000000L);
        CornerCaseArrayOfDoublesSetOperationsTest.printf("GT_LOWP:       %8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(HASH_GT_LOWP), HASH_GT_LOWP, HASH_GT_LOWP);
        CornerCaseArrayOfDoublesSetOperationsTest.printf("LOWP_THETALONG:%8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(0x1000000000000000L), 0x1000000000000000L, 0x1000000000000000L);
        CornerCaseArrayOfDoublesSetOperationsTest.printf("LT_LOWP:       %8s, %16x, %19d" + LS, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(HASH_LT_LOWP), HASH_LT_LOWP, HASH_LT_LOWP);
        CornerCaseArrayOfDoublesSetOperationsTest.println(LS + "Doubles");
        CornerCaseArrayOfDoublesSetOperationsTest.println(LS + "Longs");
        for (long v = 1L; v < 10L; ++v) {
            long hash = MurmurHash3.hash((long)v, (long)9001L)[0] >>> 1;
            CornerCaseArrayOfDoublesSetOperationsTest.printLong(v, hash);
        }
    }

    static long getLongHash(long v) {
        return MurmurHash3.hash((long)v, (long)9001L)[0] >>> 1;
    }

    static void printLong(long v, long hash) {
        System.out.printf("     %8d, %8s, %16x, %19d" + LS, v, CornerCaseArrayOfDoublesSetOperationsTest.getTop8(hash), hash, hash);
    }

    static String getTop8(long v) {
        int i = (int)(v >>> 56);
        String s = Integer.toBinaryString(i);
        return Util.zeroPad((String)s, (int)8);
    }

    private static void println(Object o) {
        System.out.println(o.toString());
    }

    private static void printf(String fmt, Object ... args) {
        System.out.printf(fmt, args);
    }

    private static enum SkType {
        EMPTY,
        EXACT,
        ESTIMATION,
        DEGENERATE;

    }

    private static class MinCombiner
    implements ArrayOfDoublesCombiner {
        MinCombiner() {
        }

        public double[] combine(double[] a, double[] b) {
            return new double[]{Math.min(a[0], b[0])};
        }
    }
}

