/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.theta.BitPacking;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.PreambleUtil;

final class MemorySegmentCompactCompressedHashIterator
implements HashIterator,
MemorySegmentStatus {
    private final MemorySegment seg;
    private int offset;
    private final int entryBits;
    private final int numEntries;
    private int index;
    private long previous;
    private int offsetBits;
    private final long[] buffer;
    private final byte[] bytes;
    private boolean isBlockMode;
    private boolean isFirstUnpack1;

    MemorySegmentCompactCompressedHashIterator(MemorySegment srcSeg, int offset, int entryBits, int numEntries) {
        this.seg = srcSeg;
        this.offset = offset;
        this.entryBits = entryBits;
        this.numEntries = numEntries;
        this.index = -1;
        this.previous = 0L;
        this.offsetBits = 0;
        this.buffer = new long[8];
        this.bytes = new byte[entryBits];
        this.isBlockMode = numEntries >= 8;
        this.isFirstUnpack1 = true;
    }

    @Override
    public long get() {
        return this.buffer[this.index & 7];
    }

    @Override
    public boolean hasMemorySegment() {
        return this.seg != null && this.seg.scope().isAlive();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.seg.isNative();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.hasMemorySegment() && MemorySegmentStatus.isSameResource(this.seg, that);
    }

    @Override
    public boolean next() {
        if (++this.index == this.numEntries) {
            return false;
        }
        if (this.isBlockMode) {
            if ((this.index & 7) == 0) {
                if (this.numEntries - this.index >= 8) {
                    this.unpack8();
                } else {
                    this.isBlockMode = false;
                    this.unpack1();
                }
            }
        } else {
            this.unpack1();
        }
        return true;
    }

    private void unpack1() {
        if (this.isFirstUnpack1) {
            MemorySegment.copy(this.seg, ValueLayout.JAVA_BYTE, this.offset, this.bytes, 0, PreambleUtil.wholeBytesToHoldBits((this.numEntries - this.index) * this.entryBits));
            this.offset = 0;
            this.isFirstUnpack1 = false;
        }
        int i = this.index & 7;
        BitPacking.unpackBits(this.buffer, i, this.entryBits, this.bytes, this.offset, this.offsetBits);
        this.offset += this.offsetBits + this.entryBits >>> 3;
        this.offsetBits = this.offsetBits + this.entryBits & 7;
        int n = i;
        this.buffer[n] = this.buffer[n] + this.previous;
        this.previous = this.buffer[i];
    }

    private void unpack8() {
        MemorySegment.copy(this.seg, ValueLayout.JAVA_BYTE, this.offset, this.bytes, 0, this.entryBits);
        BitPacking.unpackBitsBlock8(this.buffer, 0, this.bytes, 0, this.entryBits);
        this.offset += this.entryBits;
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.buffer[n] = this.buffer[n] + this.previous;
            this.previous = this.buffer[i];
        }
    }
}

