/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci.protectedItem;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public abstract class AbstractAttributeTypeProtectedItem
extends ProtectedItem {
    protected final Set<AttributeType> attributeTypes;

    protected AbstractAttributeTypeProtectedItem(Set<AttributeType> attributeTypes) {
        this.attributeTypes = Collections.unmodifiableSet(attributeTypes);
    }

    public Iterator<AttributeType> iterator() {
        return this.attributeTypes.iterator();
    }

    public int hashCode() {
        int hash = 37;
        if (this.attributeTypes != null) {
            for (AttributeType attributeType : this.attributeTypes) {
                hash = hash * 17 + attributeType.hashCode();
            }
        }
        hash = hash * 17 + this.getClass().getName().hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().isAssignableFrom(o.getClass())) {
            AbstractAttributeTypeProtectedItem that = (AbstractAttributeTypeProtectedItem)o;
            if (this.attributeTypes != null) {
                if (that.attributeTypes == null || that.attributeTypes.size() != this.attributeTypes.size()) {
                    return false;
                }
                for (AttributeType attributeType : this.attributeTypes) {
                    if (that.attributeTypes.contains(attributeType)) continue;
                    return false;
                }
                return true;
            }
            return that.attributeTypes == null;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        boolean isFirst = true;
        if (this.attributeTypes != null) {
            for (AttributeType attributeType : this.attributeTypes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(attributeType.getName());
            }
        }
        buf.append(" }");
        return buf.toString();
    }
}

