/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.DnFactory;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestBaseObject
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestBaseObject.class);

    public StoreSearchRequestBaseObject() {
        super("Store SearchRequest object Name");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        SearchRequest searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 0) {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                DnFactory dnFactory = container.getDnFactory();
                Dn baseObject = dnFactory == null ? new Dn(new String[]{dnStr}) : new Dn(new String[]{dnStr});
                searchRequest.setBase(baseObject);
            }
            catch (LdapInvalidDnException ine) {
                String msg = I18n.err((I18n)I18n.ERR_05132_INVALID_ROOT_DN, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes)});
                LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
                SearchResultDoneImpl response = new SearchResultDoneImpl(searchRequest.getMessageId());
                throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
        } else {
            searchRequest.setBase(Dn.EMPTY_DN);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05160_SEARCHING_WITH_ROOT_DN, (Object[])new Object[]{searchRequest.getBase()}));
        }
    }
}

