/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.bridge.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.util.EventListener;
import java.util.Hashtable;
import org.apache.felix.http.base.internal.AbstractHttpActivator;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.logger.SystemLogger;

public final class BridgeActivator
extends AbstractHttpActivator {
    private static final String FELIX_HTTP_SERVICE_ENDPOINTS = "org.apache.felix.http.service.endpoints";
    private static final String VENDOR = "The Apache Software Foundation";
    private static final String MARKER_PROP = "http.felix.dispatcher";

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        final Hashtable<String, String> serviceRegProps = new Hashtable<String, String>();
        if (this.getBundleContext().getProperty(FELIX_HTTP_SERVICE_ENDPOINTS) != null) {
            serviceRegProps.put("osgi.http.endpoint", this.getBundleContext().getProperty(FELIX_HTTP_SERVICE_ENDPOINTS));
        } else {
            serviceRegProps.put("osgi.http.endpoint", "/");
        }
        final Servlet dispatcherServlet = this.getHttpServiceController().createDispatcherServlet();
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = -5229577898597483605L;

            public void destroy() {
                BridgeActivator.this.getHttpServiceController().unregister();
                dispatcherServlet.destroy();
                super.destroy();
            }

            public void init(ServletConfig config) throws ServletException {
                super.init(config);
                dispatcherServlet.init(config);
                BridgeActivator.this.getHttpServiceController().register(config.getServletContext(), serviceRegProps);
            }

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                dispatcherServlet.service(req, res);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(MARKER_PROP, servlet.getClass().getName());
        props.put("service.description", "Apache Felix Http Dispatcher for bridged request handling");
        props.put("service.vendor", VENDOR);
        this.getBundleContext().registerService(HttpServlet.class.getName(), (Object)servlet, props);
        EventDispatcher dispatcher = this.getHttpServiceController().getEventDispatcher();
        dispatcher.setActive(true);
        props = new Hashtable();
        props.put(MARKER_PROP, dispatcher.getClass().getName());
        props.put("service.description", "Apache Felix Http Dispatcher for bridged event handling");
        props.put("service.vendor", VENDOR);
        this.getBundleContext().registerService(EventListener.class.getName(), (Object)dispatcher, props);
        SystemLogger.LOGGER.info("Started bridged http services");
    }
}

