/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup.actions.repo;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Jar;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoDialog
extends Dialog {
    private Text bsn;
    private Text version;
    private Label lblRepository;
    private Combo repositories;
    private List<RepositoryPlugin> repos;
    private Jar jar;
    private Label lblBundleDescription;
    private Text description;
    private RepositoryPlugin selected;

    public RepoDialog(Shell parentShell, Jar jar, List<RepositoryPlugin> repos) {
        super(parentShell);
        this.setShellStyle(2144);
        this.repos = repos;
        this.jar = jar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout(null);
        this.lblRepository = new Label(container, 0);
        this.lblRepository.setBounds(8, 8, 160, 24);
        this.lblRepository.setText("Repository");
        this.repositories = new Combo(container, 8);
        this.repositories.setBounds(168, 3, 272, 30);
        this.repositories.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepoDialog.this.selected = (RepositoryPlugin)RepoDialog.this.repos.get(RepoDialog.this.repositories.getSelectionIndex());
            }
        });
        this.bsn = new Text(container, 2048);
        this.bsn.setEditable(false);
        this.bsn.setBounds(168, 39, 272, 28);
        this.version = new Text(container, 2048);
        this.version.setEditable(false);
        this.version.setBounds(168, 67, 272, 28);
        Label lblBundleSymbolicName = new Label(container, 0);
        lblBundleSymbolicName.setBounds(8, 40, 160, 24);
        lblBundleSymbolicName.setText("Bundle Symbolic Name");
        Label lblVersion = new Label(container, 0);
        lblVersion.setBounds(8, 72, 160, 24);
        lblVersion.setText("Bundle Version");
        this.lblBundleDescription = new Label(container, 0);
        this.lblBundleDescription.setBounds(8, 105, 160, 24);
        this.lblBundleDescription.setText("Bundle Description");
        this.description = new Text(container, 2562);
        this.description.setEditable(false);
        this.description.setBounds(168, 101, 272, 117);
        this.setup();
        return container;
    }

    private void setup() {
        try {
            this.bsn.setText(this.jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName"));
            String v = this.jar.getManifest().getMainAttributes().getValue("Bundle-Version");
            if (v == null) {
                v = "0.0.0";
            }
            this.version.setText(v);
            v = this.jar.getManifest().getMainAttributes().getValue("Bundle-Description");
            if (v == null) {
                v = "";
            }
            this.description.setText(v);
            Iterator<RepositoryPlugin> i = this.repos.iterator();
            while (i.hasNext()) {
                RepositoryPlugin plugin = i.next();
                if (plugin.canWrite()) {
                    this.repositories.add(plugin.getName());
                    continue;
                }
                i.remove();
            }
            this.repositories.select(0);
            this.selected = this.repos.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setText("Deploy");
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public RepositoryPlugin getRepository() {
        return this.selected;
    }
}

