/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.felix.webconsole.internal.servlet.Base64;

class Password {
    private static final String DEFAULT_HASH_ALGO = "SHA-256";
    private static final char DELIMITER = '-';
    private static final int NO_ITERATIONS = 1;
    private static final int DEFAULT_ITERATIONS = 1000;
    public static final int DEFAULT_SALT_SIZE = 8;
    private final String hashAlgo;
    private final String password;

    static boolean isPasswordHashed(String textPassword) {
        return Password.getEndOfHashAlgorithm(textPassword) >= 0;
    }

    static String hashPassword(String textPassword) {
        String salt = Password.generateSalt(8);
        return Password.hashPassword(DEFAULT_HASH_ALGO, 1000, salt, textPassword);
    }

    Password(String textPassword) {
        this.hashAlgo = Password.getPasswordHashAlgorithm(textPassword);
        this.password = Password.getPassword(textPassword);
    }

    boolean matches(byte[] toCompare) {
        if (this.hashAlgo != null) {
            int startPos = 0;
            String salt = Password.extractSalt(this.password, startPos);
            int iterations = 1;
            if (salt != null) {
                iterations = Password.extractIterations(this.password, startPos += salt.length() + 1);
            }
            String hash = Password.hashPassword(this.hashAlgo, iterations, salt, new String(toCompare));
            StringBuilder buf = new StringBuilder();
            return Password.compareSecure(buf.append("{").append(this.hashAlgo).append("}").append(this.password).toString(), hash);
        }
        return Password.compareSecure(this.password, new String(toCompare));
    }

    private static String hashPassword(String hashAlgorithm, int iterations, String salt, String password) {
        StringBuilder buf = new StringBuilder();
        buf.append('{').append(hashAlgorithm.toLowerCase()).append('}');
        if (salt != null && !salt.isEmpty()) {
            buf.append(salt).append('-');
            if (iterations > 1) {
                buf.append(iterations).append('-');
            }
            byte[] hashedPassword = Password.hashPassword(password, salt, iterations, hashAlgorithm);
            buf.append(Base64.newStringUtf8(Base64.encodeBase64(hashedPassword)));
        } else {
            byte[] hashedPassword = Password.hashPassword(password, null, 1, hashAlgorithm);
            buf.append(Base64.newStringUtf8(Base64.encodeBase64(hashedPassword)));
        }
        return buf.toString();
    }

    private static String getPasswordHashAlgorithm(String textPassword) {
        int endHash = Password.getEndOfHashAlgorithm(textPassword);
        if (endHash >= 0) {
            return textPassword.substring(1, endHash);
        }
        return null;
    }

    private static String getPassword(String textPassword) {
        int endHash = Password.getEndOfHashAlgorithm(textPassword);
        if (endHash >= 0) {
            String encodedPassword = textPassword.substring(endHash + 1);
            return encodedPassword;
        }
        return textPassword;
    }

    private static int getEndOfHashAlgorithm(String textPassword) {
        int endHash;
        if (textPassword.startsWith("{") && (endHash = textPassword.indexOf("}")) > 0) {
            return endHash;
        }
        return -1;
    }

    private static byte[] hashPassword(String pwd, String salt, int iterations, String hashAlg) {
        try {
            StringBuilder data = new StringBuilder();
            if (salt != null) {
                data.append(salt);
            }
            data.append(pwd);
            byte[] bytes = Base64.getBytesUtf8(data.toString());
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            for (int i = 0; i < iterations; ++i) {
                md.reset();
                bytes = md.digest(bytes);
            }
            return bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot hash the password: " + e);
        }
    }

    private static boolean compareSecure(String a, String b) {
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int bits = 0;
        for (int i = 0; i < len; ++i) {
            bits |= a.charAt(i) ^ b.charAt(i);
        }
        return bits == 0;
    }

    private static String generateSalt(int saltSize) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[saltSize];
        random.nextBytes(salt);
        return Password.toHex(salt);
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    private static String extractSalt(String hashedPwd, int start) {
        int end;
        if (hashedPwd != null && (end = hashedPwd.indexOf(45, start)) > -1) {
            return hashedPwd.substring(start, end);
        }
        return null;
    }

    private static int extractIterations(String hashedPwd, int start) {
        int end;
        if (hashedPwd != null && (end = hashedPwd.indexOf(45, start)) > -1) {
            String str = hashedPwd.substring(start, end);
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }
}

