/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;

public class WritableByteChannelMock
implements WritableByteChannel {
    private final int capacityLimit;
    private int capacityUsed;
    private ByteBuffer buf;
    private boolean closed;

    public WritableByteChannelMock(int initialSize, int capacityLimit) {
        this.buf = ByteBuffer.allocate(initialSize);
        this.capacityLimit = capacityLimit;
    }

    public WritableByteChannelMock(int initialSize) {
        this(initialSize, 0);
    }

    private void expandCapacity(int capacity) {
        ByteBuffer oldbuffer = this.buf;
        this.buf = ByteBuffer.allocate(capacity);
        oldbuffer.flip();
        this.buf.put(oldbuffer);
    }

    private void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.buf.capacity()) {
            this.expandCapacity(requiredCapacity);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        int len = src.remaining();
        this.ensureCapacity(this.buf.position() + len);
        if (this.capacityLimit > 0) {
            int chunk = Math.min(this.capacityLimit - this.capacityUsed, len);
            if (chunk > 0) {
                int limit = src.limit();
                src.limit(src.position() + chunk);
                this.buf.put(src);
                src.limit(limit);
                this.capacityUsed += chunk;
                return chunk;
            }
            return 0;
        }
        this.buf.put(src);
        return len;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public void flush() {
        this.capacityUsed = 0;
    }

    public void reset() {
        this.capacityUsed = 0;
        this.buf.clear();
    }

    public byte[] toByteArray() {
        ByteBuffer dup = this.buf.duplicate();
        dup.flip();
        byte[] bytes = new byte[dup.remaining()];
        dup.get(bytes);
        return bytes;
    }

    public String dump(Charset charset) throws CharacterCodingException {
        this.buf.flip();
        CharBuffer charBuffer = charset.newDecoder().decode(this.buf);
        this.buf.compact();
        return charBuffer.toString();
    }
}

