/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TestDefaultBHttpServerConnection {
    @Mock
    private Socket socket;
    private DefaultBHttpServerConnection conn;

    TestDefaultBHttpServerConnection() {
    }

    @BeforeEach
    void prepareMocks() {
        MockitoAnnotations.openMocks((Object)this);
        this.conn = new DefaultBHttpServerConnection("http", Http1Config.DEFAULT, null, null, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (HttpMessageParserFactory)DefaultHttpRequestParserFactory.INSTANCE, (HttpMessageWriterFactory)DefaultHttpResponseWriterFactory.INSTANCE);
    }

    @Test
    void testBasics() {
        Assertions.assertFalse((boolean)this.conn.isOpen());
        Assertions.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    void testReadRequestHead() throws Exception {
        String s = "GET / HTTP/1.1\r\nUser-Agent: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("GET / HTTP/1.1\r\nUser-Agent: test\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        ClassicHttpRequest request = this.conn.receiveRequestHeader();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((Object)"/", (Object)request.getPath());
        Assertions.assertEquals((Object)Method.GET.name(), (Object)request.getMethod());
        Assertions.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        Assertions.assertNull((Object)this.conn.getEndpointDetails().getRemoteAddress());
        Assertions.assertNull((Object)this.conn.getEndpointDetails().getLocalAddress());
        Assertions.assertEquals((Object)Timeout.ofMilliseconds((long)0L), (Object)this.conn.getEndpointDetails().getSocketTimeout());
        Assertions.assertEquals((Object)"null<->null", (Object)this.conn.getEndpointDetails().toString());
    }

    @Test
    void testReadRequestEntityWithContentLength() throws Exception {
        String s = "POST / HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("POST / HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        ClassicHttpRequest request = this.conn.receiveRequestHeader();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((Object)"/", (Object)request.getPath());
        Assertions.assertEquals((Object)Method.POST.name(), (Object)request.getMethod());
        Assertions.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assertions.assertNull((Object)request.getEntity());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        this.conn.receiveRequestEntity(request);
        HttpEntity entity = request.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((long)3L, (long)entity.getContentLength());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertTrue((boolean)(content instanceof ContentLengthInputStream));
    }

    @Test
    void testReadRequestEntityChunckCoded() throws Exception {
        String s = "POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        ClassicHttpRequest request = this.conn.receiveRequestHeader();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)Method.POST.name(), (Object)request.getMethod());
        Assertions.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assertions.assertNull((Object)request.getEntity());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        this.conn.receiveRequestEntity(request);
        HttpEntity entity = request.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        Assertions.assertTrue((boolean)entity.isChunked());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertTrue((boolean)(content instanceof ChunkedInputStream));
    }

    @Test
    void testReadRequestEntityIdentity() throws Exception {
        String s = "POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: identity\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: identity\r\n\r\n123".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        ClassicHttpRequest request = this.conn.receiveRequestHeader();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)Method.POST.name(), (Object)request.getMethod());
        Assertions.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assertions.assertNull((Object)request.getEntity());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        Assertions.assertThrows(ProtocolException.class, () -> this.conn.receiveRequestEntity(request));
    }

    @Test
    void testReadRequestNoEntity() throws Exception {
        String s = "POST /stuff HTTP/1.1\r\nUser-Agent: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("POST /stuff HTTP/1.1\r\nUser-Agent: test\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        ClassicHttpRequest request = this.conn.receiveRequestHeader();
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((Object)"/stuff", (Object)request.getPath());
        Assertions.assertEquals((Object)Method.POST.name(), (Object)request.getMethod());
        Assertions.assertTrue((boolean)request.containsHeader("User-Agent"));
        Assertions.assertNull((Object)request.getEntity());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        this.conn.receiveRequestEntity(request);
        HttpEntity entity = request.getEntity();
        Assertions.assertNull((Object)entity);
    }

    @Test
    void testWriteResponseHead() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("User-Agent", (Object)"test");
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n", (Object)s);
    }

    @Test
    void testWriteResponse100Head() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(100, "Go on");
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        this.conn.flush();
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 100 Go on\r\n\r\n", (Object)s);
    }

    @Test
    void testWriteResponseEntityWithContentLength() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("Server", (Object)"test");
        response.addHeader("Content-Length", (Object)"3");
        response.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        this.conn.sendResponseEntity((ClassicHttpResponse)response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nServer: test\r\nContent-Length: 3\r\n\r\n123", (Object)s);
    }

    @Test
    void testWriteResponseEntityChunkCoded() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("Server", (Object)"test");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        this.conn.sendResponseEntity((ClassicHttpResponse)response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nServer: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n", (Object)s);
    }

    @Test
    void testWriteResponseEntityIdentity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("Server", (Object)"test");
        response.addHeader("Transfer-Encoding", (Object)"identity");
        response.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        Assertions.assertThrows(NotImplementedException.class, () -> this.lambda$testWriteResponseEntityIdentity$1((ClassicHttpResponse)response));
        this.conn.flush();
    }

    @Test
    void testWriteResponseNoEntity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("Server", (Object)"test");
        this.conn.sendResponseHeader((ClassicHttpResponse)response);
        this.conn.sendResponseEntity((ClassicHttpResponse)response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nServer: test\r\n\r\n", (Object)s);
    }

    private /* synthetic */ void lambda$testWriteResponseEntityIdentity$1(ClassicHttpResponse response) throws Throwable {
        this.conn.sendResponseEntity(response);
    }
}

