/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestHttpRequestExecutor {
    TestHttpRequestExecutor() {
    }

    @Test
    void testInvalidInput() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        Assertions.assertThrows(NullPointerException.class, () -> {
            HttpRequestExecutor executor = new HttpRequestExecutor();
            executor.execute(null, conn, (HttpContext)context);
        });
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$1((ClassicHttpRequest)request, context));
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$2((ClassicHttpRequest)request, conn));
        Assertions.assertThrows(NullPointerException.class, () -> {
            HttpRequestExecutor executor = new HttpRequestExecutor();
            executor.preProcess(null, httprocessor, (HttpContext)context);
        });
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$4((ClassicHttpRequest)request, context));
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$5((ClassicHttpRequest)request, httprocessor));
        Assertions.assertThrows(NullPointerException.class, () -> {
            HttpRequestExecutor executor = new HttpRequestExecutor();
            executor.postProcess(null, httprocessor, (HttpContext)context);
        });
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$7((ClassicHttpResponse)response, context));
        Assertions.assertThrows(NullPointerException.class, () -> TestHttpRequestExecutor.lambda$testInvalidInput$8((ClassicHttpResponse)response, httprocessor));
    }

    @Test
    void testBasicExecution() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(200, "OK"));
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    void testExecutionSkipIntermediateResponses() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(100, "Continue"), (Object[])new ClassicHttpResponse[]{new BasicClassicHttpResponse(110, "Huh?"), new BasicClassicHttpResponse(111, "Huh?"), new BasicClassicHttpResponse(200, "OK")});
        HttpResponseInformationCallback callback = (HttpResponseInformationCallback)Mockito.mock(HttpResponseInformationCallback.class);
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, callback, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)4))).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).receiveResponseEntity(response);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseInformationCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).execute((HttpResponse)responseCaptor.capture(), (HttpConnection)ArgumentMatchers.eq((Object)conn), (HttpContext)ArgumentMatchers.eq((Object)context));
        List infos = responseCaptor.getAllValues();
        Assertions.assertNotNull((Object)infos);
        Assertions.assertEquals((int)2, (int)infos.size());
        HttpResponse info1 = (HttpResponse)infos.get(0);
        Assertions.assertNotNull((Object)info1);
        Assertions.assertEquals((int)110, (int)info1.getCode());
        HttpResponse info2 = (HttpResponse)infos.get(1);
        Assertions.assertNotNull((Object)info2);
        Assertions.assertEquals((int)111, (int)info2.getCode());
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Assertions.assertSame((Object)request, (Object)context.getRequest());
        Assertions.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    void testExecutionNoResponseBody() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(204, "OK"));
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionHead() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.HEAD, "/");
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(200, "OK"));
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionEntityEnclosingRequest() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(200, "OK"));
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionEntityEnclosingRequestWithExpectContinueSuccess() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader("Expect", (Object)"100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(100, "Continue"), (Object[])new ClassicHttpResponse[]{new BasicClassicHttpResponse(200, "OK")});
        Mockito.when((Object)conn.isDataAvailable((Timeout)ArgumentMatchers.any(Timeout.class))).thenReturn((Object)Boolean.TRUE);
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isDataAvailable(Timeout.ofMilliseconds((long)3000L));
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionEntityEnclosingRequestWithExpectContinueFailure() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader("Expect", (Object)"100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(402, "OK"));
        Mockito.when((Object)conn.isDataAvailable((Timeout)ArgumentMatchers.any(Timeout.class))).thenReturn((Object)Boolean.TRUE);
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).sendRequestEntity((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).terminateRequest((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isDataAvailable(Timeout.ofMilliseconds((long)3000L));
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionEntityEnclosingRequestWithExpectContinueMultiple1xxResponses() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader("Expect", (Object)"100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(110, "Huh?"), (Object[])new ClassicHttpResponse[]{new BasicClassicHttpResponse(100, "Continue"), new BasicClassicHttpResponse(111, "Huh?"), new BasicClassicHttpResponse(200, "OK")});
        Mockito.when((Object)conn.isDataAvailable((Timeout)ArgumentMatchers.any(Timeout.class))).thenReturn((Object)Boolean.TRUE);
        HttpResponseInformationCallback callback = (HttpResponseInformationCallback)Mockito.mock(HttpResponseInformationCallback.class);
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, callback, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).isDataAvailable(Timeout.ofMilliseconds((long)3000L));
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)4))).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseInformationCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)2))).execute((HttpResponse)responseCaptor.capture(), (HttpConnection)ArgumentMatchers.eq((Object)conn), (HttpContext)ArgumentMatchers.eq((Object)context));
        List infos = responseCaptor.getAllValues();
        Assertions.assertNotNull((Object)infos);
        Assertions.assertEquals((int)2, (int)infos.size());
        HttpResponse info1 = (HttpResponse)infos.get(0);
        Assertions.assertNotNull((Object)info1);
        Assertions.assertEquals((int)110, (int)info1.getCode());
        HttpResponse info2 = (HttpResponse)infos.get(1);
        Assertions.assertNotNull((Object)info2);
        Assertions.assertEquals((int)111, (int)info2.getCode());
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionEntityEnclosingRequestWithExpectContinueNoResponse() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader("Expect", (Object)"100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((ClassicHttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicClassicHttpResponse(200, "OK"));
        Mockito.when((Object)conn.isDataAvailable((Timeout)ArgumentMatchers.any(Timeout.class))).thenReturn((Object)Boolean.FALSE);
        ClassicHttpResponse response = executor.execute((ClassicHttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((ClassicHttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isDataAvailable(Timeout.ofMilliseconds((long)3000L));
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    @Test
    void testExecutionIOException() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        ((HttpClientConnection)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Oopsie")}).when((Object)conn)).sendRequestHeader((ClassicHttpRequest)request);
        Assertions.assertThrows(IOException.class, () -> TestHttpRequestExecutor.lambda$testExecutionIOException$9(executor, (ClassicHttpRequest)request, conn, context));
        ((HttpClientConnection)Mockito.verify((Object)conn)).close(CloseMode.IMMEDIATE);
    }

    @Test
    void testExecutionRuntimeException() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        ((HttpClientConnection)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Oopsie")}).when((Object)conn)).receiveResponseHeader();
        Assertions.assertThrows(RuntimeException.class, () -> TestHttpRequestExecutor.lambda$testExecutionRuntimeException$10(executor, (ClassicHttpRequest)request, conn, context));
        ((HttpClientConnection)Mockito.verify((Object)conn)).close(CloseMode.IMMEDIATE);
    }

    @Test
    void testExecutionHttpException() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        ((HttpClientConnection)Mockito.doThrow((Throwable[])new Throwable[]{new HttpException("Oopsie")}).when((Object)conn)).receiveResponseHeader();
        Assertions.assertThrows(HttpException.class, () -> TestHttpRequestExecutor.lambda$testExecutionHttpException$11(executor, (ClassicHttpRequest)request, conn, context));
        ((HttpClientConnection)Mockito.verify((Object)conn)).close();
    }

    private static /* synthetic */ void lambda$testExecutionHttpException$11(HttpRequestExecutor executor, ClassicHttpRequest request, HttpClientConnection conn, HttpCoreContext context) throws Throwable {
        executor.execute(request, conn, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testExecutionRuntimeException$10(HttpRequestExecutor executor, ClassicHttpRequest request, HttpClientConnection conn, HttpCoreContext context) throws Throwable {
        executor.execute(request, conn, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testExecutionIOException$9(HttpRequestExecutor executor, ClassicHttpRequest request, HttpClientConnection conn, HttpCoreContext context) throws Throwable {
        executor.execute(request, conn, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testInvalidInput$8(ClassicHttpResponse response, HttpProcessor httprocessor) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.postProcess(response, httprocessor, null);
    }

    private static /* synthetic */ void lambda$testInvalidInput$7(ClassicHttpResponse response, HttpCoreContext context) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.postProcess(response, null, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testInvalidInput$5(ClassicHttpRequest request, HttpProcessor httprocessor) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.preProcess(request, httprocessor, null);
    }

    private static /* synthetic */ void lambda$testInvalidInput$4(ClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.preProcess(request, null, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testInvalidInput$2(ClassicHttpRequest request, HttpClientConnection conn) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.execute(request, conn, null);
    }

    private static /* synthetic */ void lambda$testInvalidInput$1(ClassicHttpRequest request, HttpCoreContext context) throws Throwable {
        HttpRequestExecutor executor = new HttpRequestExecutor();
        executor.execute(request, null, (HttpContext)context);
    }
}

