﻿/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Apache.Ignite.Internal.Linq;

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

/// <summary>
/// Contains static methods to work with IEnumerable.
/// </summary>
internal static class EnumerableHelper
{
    /// <summary>
    /// Gets item type of enumerable.
    /// </summary>
    /// <param name="type">Enumerable type.</param>
    /// <returns>Item type.</returns>
    public static Type GetIEnumerableItemType(Type type)
    {
        if (type.IsGenericType && type.GetGenericTypeDefinition() == typeof(IEnumerable<>))
        {
            return type.GetGenericArguments()[0];
        }

        var implementedIEnumerableType = type.GetInterfaces()
            .FirstOrDefault(t => t.IsGenericType && t.GetGenericTypeDefinition() == typeof(IEnumerable<>));

        if (implementedIEnumerableType != null)
        {
            return implementedIEnumerableType.GetGenericArguments()[0];
        }

        if (type == typeof(IEnumerable))
        {
            return typeof(object);
        }

        throw new NotSupportedException("Type is not IEnumerable: " + type.FullName);
    }
}
