/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.call;

import java.util.Objects;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.CallOutputStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultCallOutput<T>
implements CallOutput<T> {
    private final CallOutputStatus status;
    private final T body;
    private final Throwable cause;

    private DefaultCallOutput(CallOutputStatus status, T body, Throwable cause) {
        this.status = status;
        this.body = body;
        this.cause = cause;
    }

    @Override
    public boolean hasError() {
        return this.cause != null;
    }

    @Override
    public boolean isEmpty() {
        return CallOutputStatus.EMPTY.equals((Object)this.status);
    }

    @Override
    public Throwable errorCause() {
        return this.cause;
    }

    @Override
    public T body() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCallOutput that = (DefaultCallOutput)o;
        return this.status == that.status && Objects.equals(this.body, that.body) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.body, this.cause});
    }

    public String toString() {
        return "DefaultCallOutput{status=" + String.valueOf((Object)this.status) + ", body='" + String.valueOf(this.body) + "', cause=" + String.valueOf(this.cause) + "}";
    }

    public static <T> DefaultCallOutputBuilder<T> builder() {
        return new DefaultCallOutputBuilder();
    }

    public static <T> DefaultCallOutput<T> success(@Nullable T body) {
        return DefaultCallOutput.builder().status(CallOutputStatus.SUCCESS).body(body).build();
    }

    public static <T> DefaultCallOutput<T> failure(Throwable cause) {
        return DefaultCallOutput.builder().status(CallOutputStatus.ERROR).cause(cause).build();
    }

    public static <T> DefaultCallOutput<T> empty() {
        return DefaultCallOutput.builder().status(CallOutputStatus.EMPTY).build();
    }

    public static class DefaultCallOutputBuilder<T> {
        private CallOutputStatus status;
        private T body;
        private Throwable cause;

        public DefaultCallOutputBuilder<T> status(CallOutputStatus status) {
            this.status = status;
            return this;
        }

        public DefaultCallOutputBuilder<T> body(T body) {
            this.body = body;
            return this;
        }

        public DefaultCallOutputBuilder<T> cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DefaultCallOutput<T> build() {
            return new DefaultCallOutput<T>(this.status, this.body, this.cause);
        }
    }
}

