/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.HandshakeExtension;

public class HandshakeUtils {
    public static final BitSet EMPTY_FEATURES = new BitSet();
    public static final int CLIENT_TYPE_GENERAL = 2;

    public static void packExtensions(ClientMessagePacker packer, Map<HandshakeExtension, Object> extensions) {
        packer.packInt(extensions.size());
        for (Map.Entry<HandshakeExtension, Object> entry : extensions.entrySet()) {
            packer.packString(entry.getKey().key());
            packer.packString((String)entry.getValue());
        }
    }

    public static Map<HandshakeExtension, Object> unpackExtensions(ClientMessageUnpacker unpacker) {
        EnumMap<HandshakeExtension, Object> extensions = new EnumMap<HandshakeExtension, Object>(HandshakeExtension.class);
        int mapSize = unpacker.unpackInt();
        for (int i = 0; i < mapSize; ++i) {
            String key = unpacker.unpackString();
            HandshakeExtension handshakeExtension = HandshakeExtension.fromKey(key);
            if (handshakeExtension != null) {
                extensions.put(handshakeExtension, HandshakeUtils.unpackExtensionValue(handshakeExtension, unpacker));
                continue;
            }
            unpacker.skipValues(1);
        }
        return extensions;
    }

    public static void packFeatures(ClientMessagePacker packer, BitSet features) {
        packer.packBinary(features.toByteArray());
    }

    public static BitSet unpackFeatures(ClientMessageUnpacker unpacker) {
        return BitSet.valueOf(unpacker.readBinary());
    }

    private static Object unpackExtensionValue(HandshakeExtension handshakeExtension, ClientMessageUnpacker unpacker) {
        Class<?> type = handshakeExtension.valueType();
        if (type == String.class) {
            return unpacker.unpackString();
        }
        throw new IllegalArgumentException("Unsupported extension type: " + type.getName());
    }
}

