/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite.internal.cli.util.ConfigurationArgsParseException;
import picocli.CommandLine;

public class SpacedParameterMixin {
    @CommandLine.Parameters(arity="0..1")
    private String[] args;
    @CommandLine.Option(names={"--file"}, description={"Path to file with config update commands to execute"})
    public File configFile;

    private String configUpdateFromArgs() {
        return Arrays.stream(this.args).map(SpacedParameterMixin::unquote).collect(Collectors.joining(" "));
    }

    private static String unquote(String rawString) {
        if (SpacedParameterMixin.isQuoted(rawString, '\"') || SpacedParameterMixin.isQuoted(rawString, '\'') || SpacedParameterMixin.isQuoted(rawString, '`')) {
            return rawString.substring(1, rawString.length() - 1);
        }
        return rawString;
    }

    private static boolean isQuoted(String string, char quoteChar) {
        return string.charAt(0) == quoteChar && string.charAt(string.length() - 1) == quoteChar;
    }

    public boolean hasContent() {
        return this.args != null && this.args.length > 0;
    }

    public String formUpdateConfig() {
        if (this.configFile == null && !this.hasContent()) {
            throw new ConfigurationArgsParseException("Failed to parse config content. Please, specify config file or provide config content directly.");
        }
        if (this.configFile == null) {
            return this.configUpdateFromArgs();
        }
        if (!Files.exists(this.configFile.toPath(), new LinkOption[0])) {
            throw new IgniteCliException("File [" + this.configFile.getAbsolutePath() + "] not found");
        }
        Config result = ConfigFactory.parseFile((File)this.configFile);
        if (this.hasContent()) {
            Config configFromArgs = ConfigFactory.parseString((String)this.configUpdateFromArgs());
            result = configFromArgs.withFallback((ConfigMergeable)result);
        }
        return result.resolve().root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(false));
    }
}

