/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.util;

import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlainTableRenderer {
    private static final String COLUMN_DELIMITER = "\t";
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static String render(String[] hdr, Object[][] content) {
        StringJoiner sj = new StringJoiner(LINE_SEPARATOR);
        sj.add(PlainTableRenderer.tableRowToString(hdr));
        for (Object[] row : content) {
            sj.add(PlainTableRenderer.tableRowToString(row));
        }
        return sj.toString();
    }

    private static String tableRowToString(Object[] row) {
        return Stream.of(row).map(String::valueOf).collect(Collectors.joining(COLUMN_DELIMITER));
    }
}

