/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.params;

import org.apache.ignite3.client.BasicAuthenticator;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public class IgniteClientAuthenticatorParams {
    @CommandLine.Option(names={"--client.basicAuthenticator.username"}, description={"Username for authenticating the client. The password should be defined using the 'IGNITE_CLIENT_SECRET' environment variable."})
    @Nullable
    private String username;

    @Nullable
    public BasicAuthenticator authenticator() {
        if (this.username == null) {
            return null;
        }
        String password = System.getenv("IGNITE_CLIENT_SECRET");
        if (password == null) {
            throw new IllegalArgumentException("'IGNITE_CLIENT_SECRET' environment variable was not defined.");
        }
        return new BasicAuthenticator.Builder().username(this.username).password(password).build();
    }
}

