/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.types;

import java.util.Objects;
import org.apache.ignite.migrationtools.types.InspectedFieldType;
import org.jetbrains.annotations.Nullable;

public class InspectedField {
    @Nullable
    private final String fieldName;
    private final String typeName;
    private final InspectedFieldType fieldType;
    private final boolean nullable;
    private final boolean hasAnnotation;

    private InspectedField(@Nullable String fieldName, String typeName, InspectedFieldType fieldType, boolean nullable, boolean hasAnnotation) {
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.fieldType = fieldType;
        this.nullable = nullable;
        this.hasAnnotation = hasAnnotation;
    }

    public static InspectedField forUnnamed(String typeName, InspectedFieldType fieldType) {
        if (fieldType != InspectedFieldType.PRIMITIVE && fieldType != InspectedFieldType.ARRAY) {
            throw new IllegalArgumentException("'fieldType' must be PRIMITIVE or ARRAY");
        }
        return new InspectedField(null, typeName, fieldType, false, false);
    }

    public static InspectedField forNamed(String fieldName, String typeName, InspectedFieldType fieldType, boolean nullable, boolean hasAnnotation) {
        if (fieldType == InspectedFieldType.PRIMITIVE || fieldType == InspectedFieldType.ARRAY) {
            throw new IllegalArgumentException("'fieldType' must not be PRIMITIVE or ARRAY");
        }
        return new InspectedField(fieldName, typeName, fieldType, nullable, hasAnnotation);
    }

    @Nullable
    public String fieldName() {
        return this.fieldName;
    }

    public String typeName() {
        return this.typeName;
    }

    public InspectedFieldType fieldType() {
        return this.fieldType;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean hasAnnotation() {
        return this.hasAnnotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectedField that = (InspectedField)o;
        return this.nullable == that.nullable && this.hasAnnotation == that.hasAnnotation && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.typeName, that.typeName) && this.fieldType == that.fieldType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.typeName, this.fieldType, this.nullable, this.hasAnnotation});
    }

    public String toString() {
        return "InspectedField{fieldName='" + this.fieldName + "', typeName='" + this.typeName + "', fieldType=" + this.fieldType + ", nullable=" + this.nullable + ", hasAnnotation=" + this.hasAnnotation + "}";
    }
}

