/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public enum CacheMode {
    REPLICATED(1),
    PARTITIONED(2);

    private static final CacheMode[] BY_CODE;
    private final byte code;

    private CacheMode(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    @Nullable
    public static CacheMode fromCode(int code) {
        return code >= 0 && code < BY_CODE.length ? BY_CODE[code] : null;
    }

    public static byte toCode(@Nullable CacheMode mode) {
        return mode == null ? (byte)-1 : (byte)mode.code;
    }

    static {
        int max = Stream.of(CacheMode.values()).mapToInt(e -> e.code).max().orElseThrow(RuntimeException::new);
        BY_CODE = new CacheMode[max + 1];
        CacheMode[] cacheModeArray = CacheMode.values();
        int n = cacheModeArray.length;
        for (int i = 0; i < n; ++i) {
            CacheMode e2;
            CacheMode.BY_CODE[e2.code] = e2 = cacheModeArray[i];
        }
    }
}

