/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClusterNodeLocalMapImpl<K, V>
extends ConcurrentHashMap<K, V>
implements ConcurrentMap<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<String> stash = new ThreadLocal();
    private GridKernalContext ctx;

    public ClusterNodeLocalMapImpl() {
    }

    ClusterNodeLocalMapImpl(GridKernalContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.ctx.igniteInstanceName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        stash.set(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            ConcurrentMap concurrentMap = IgnitionEx.localIgnite().cluster().nodeLocalMap();
            return concurrentMap;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public String toString() {
        return S.toString(ClusterNodeLocalMapImpl.class, this);
    }
}

