/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheValidateIndexesCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(example="cacheName1,...,cacheNameN", optional=true)
    private String value;
    @Positional
    @Argument(example="nodeId", optional=true)
    private String value2;
    private String[] caches;
    private UUID[] nodeIds;
    @Argument(example="N", description="validate only the first N keys", optional=true)
    private int checkFirst = -1;
    @Argument(example="K", description="validate every Kth key", optional=true)
    private int checkThrough = -1;
    @Argument(description="check the CRC-sum of pages stored on disk", optional=true)
    private boolean checkCrc;
    @Argument(description="check that index size and cache size are the same", optional=true)
    private boolean checkSizes;

    private static void ensurePositive(int numVal, String arg) {
        if (numVal <= 0) {
            throw new IllegalArgumentException("Value for '" + arg + "' property should be positive.");
        }
    }

    private void parse(String value) {
        try {
            this.nodeIds = CommandUtils.parseVal(value, UUID[].class);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.caches = CommandUtils.parseVal(value, String[].class);
            return;
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.value);
        U.writeString(out, this.value2);
        U.writeArray(out, this.caches);
        U.writeArray(out, this.nodeIds);
        out.writeInt(this.checkFirst);
        out.writeInt(this.checkThrough);
        out.writeBoolean(this.checkCrc);
        out.writeBoolean(this.checkSizes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = U.readString(in);
        this.value2 = U.readString(in);
        this.caches = U.readArray(in, String.class);
        this.nodeIds = U.readArray(in, UUID.class);
        this.checkFirst = in.readInt();
        this.checkThrough = in.readInt();
        this.checkCrc = in.readBoolean();
        this.checkSizes = in.readBoolean();
    }

    public String value2() {
        return this.value2;
    }

    public void value2(String value2) {
        this.value2 = value2;
        this.parse(value2);
    }

    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
        this.parse(value);
    }

    public UUID[] nodeIds() {
        return this.nodeIds;
    }

    public void nodeIds(UUID[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String[] caches() {
        return this.caches;
    }

    public void caches(String[] caches) {
        this.caches = caches;
    }

    public int checkFirst() {
        return this.checkFirst;
    }

    public void checkFirst(int checkFirst) {
        if (this.checkFirst == checkFirst) {
            return;
        }
        CacheValidateIndexesCommandArg.ensurePositive(checkFirst, "--check-first");
        this.checkFirst = checkFirst;
    }

    public int checkThrough() {
        return this.checkThrough;
    }

    public void checkThrough(int checkThrough) {
        if (this.checkThrough == checkThrough) {
            return;
        }
        CacheValidateIndexesCommandArg.ensurePositive(checkThrough, "--check-through");
        this.checkThrough = checkThrough;
    }

    public boolean checkCrc() {
        return this.checkCrc;
    }

    public void checkCrc(boolean checkCrc) {
        this.checkCrc = checkCrc;
    }

    public boolean checkSizes() {
        return this.checkSizes;
    }

    public void checkSizes(boolean checkSizes) {
        this.checkSizes = checkSizes;
    }
}

