/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotVerifyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSnapshotVerificationTask
extends ComputeTaskAdapter<SnapshotPartitionsVerifyTaskArg, SnapshotPartitionsVerifyTaskResult> {
    private static final long serialVersionUID = 0L;
    protected final Map<ClusterNode, List<SnapshotMetadata>> metas = new HashMap<ClusterNode, List<SnapshotMetadata>>();
    @IgniteInstanceResource
    protected IgniteEx ignite;
    @LoggerResource
    protected IgniteLogger log;

    @Override
    public Map<ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, SnapshotPartitionsVerifyTaskArg arg) {
        Map<ClusterNode, List<SnapshotMetadata>> clusterMetas = arg.clusterMetadata();
        if (!subgrid.containsAll(clusterMetas.keySet())) {
            throw new IgniteSnapshotVerifyException(F.asMap(this.ignite.localNode(), new IgniteException("Some of Ignite nodes left the cluster during the snapshot verification [curr=" + F.viewReadOnly(subgrid, F.node2id(), new IgnitePredicate[0]) + ", init=" + F.viewReadOnly(clusterMetas.keySet(), F.node2id(), new IgnitePredicate[0]) + "]")));
        }
        HashMap<ComputeJob, ClusterNode> jobs = new HashMap<ComputeJob, ClusterNode>();
        HashSet allMetas = new HashSet();
        clusterMetas.values().forEach(allMetas::addAll);
        this.metas.putAll(clusterMetas);
        block0: while (!allMetas.isEmpty()) {
            for (Map.Entry<ClusterNode, List<SnapshotMetadata>> e : clusterMetas.entrySet()) {
                IgnitePredicate[] ignitePredicateArray = new IgnitePredicate[1];
                ignitePredicateArray[0] = allMetas::remove;
                SnapshotMetadata meta = F.find((Iterable)e.getValue(), null, ignitePredicateArray);
                if (meta == null) continue;
                jobs.put(this.createJob(meta.snapshotName(), meta.consistentId(), arg), e.getKey());
                if (!allMetas.isEmpty()) continue;
                continue block0;
            }
        }
        return jobs;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return ComputeJobResultPolicy.WAIT;
    }

    protected abstract AbstractSnapshotVerificationJob createJob(String var1, String var2, SnapshotPartitionsVerifyTaskArg var3);

    protected static abstract class AbstractSnapshotVerificationJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected IgniteEx ignite;
        @LoggerResource
        protected IgniteLogger log;
        protected final String snpName;
        @Nullable
        protected final String snpPath;
        protected final String consId;
        @Nullable
        protected final Collection<String> rqGrps;
        protected final boolean check;

        protected AbstractSnapshotVerificationJob(String snpName, @Nullable String snpPath, String consId, @Nullable Collection<String> rqGrps, boolean check) {
            this.snpName = snpName;
            this.snpPath = snpPath;
            this.consId = consId;
            this.rqGrps = rqGrps;
            this.check = check;
        }
    }
}

