/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.BufferedFileIO;

public class WriteOnlyZipFileIO
extends BufferedFileIO {
    private final ZipOutputStream zos = new ZipOutputStream(new OutputStream(){

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            WriteOnlyZipFileIO.super.writeBytes(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            WriteOnlyZipFileIO.this.writeByte((byte)b);
        }
    });

    public WriteOnlyZipFileIO(FileIO fileIO, String entryName) throws IOException {
        super(fileIO);
        this.zos.setLevel(9);
        this.zos.putNextEntry(new ZipEntry(entryName));
    }

    @Override
    protected void writeBytes(byte[] srcBuf, int off, int len) throws IOException {
        this.zos.write(srcBuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.zos.close();
        super.close();
    }
}

